/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.images;

import java.io.InputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.version.VersionHistory;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/images/")
public class RESTImagesRendererService
implements ResourceContainer {
    private SessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    static Log log = ExoLogger.getLogger(RESTImagesRendererService.class);

    public RESTImagesRendererService(RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{nodeIdentifier}")
    public Response serveImage(@PathParam(value="repositoryName") String repository, @PathParam(value="workspaceName") String workspace, @PathParam(value="nodeIdentifier") String nodeIdentifier, @QueryParam(value="param") @DefaultValue(value="file") String param) {
        try {
            SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
            WCMService wcmService = WCMCoreUtils.getService(WCMService.class);
            Node node = wcmService.getReferencedContent(sessionProvider, repository, workspace, nodeIdentifier);
            if (node == null) {
                return Response.status((int)404).build();
            }
            if ("file".equals(param)) {
                Node dataNode = null;
                if (node.isNodeType("nt:file")) {
                    dataNode = node;
                } else if (node.isNodeType("nt:versionedChild")) {
                    VersionHistory versionHistory = (VersionHistory)node.getProperty("jcr:childVersionHistory").getNode();
                    String versionableUUID = versionHistory.getVersionableUUID();
                    dataNode = sessionProvider.getSession(workspace, this.repositoryService.getRepository(repository)).getNodeByUUID(versionableUUID);
                } else {
                    return Response.status((int)404).build();
                }
                InputStream jcrData = dataNode.getNode("jcr:content").getProperty("jcr:data").getStream();
                return Response.ok((Object)jcrData, (String)"image").build();
            }
            InputStream jcrData = node.getProperty(param).getStream();
            return Response.ok((Object)jcrData, (String)"image").build();
        }
        catch (PathNotFoundException e) {
            return Response.status((int)404).build();
        }
        catch (ItemNotFoundException e) {
            return Response.status((int)404).build();
        }
        catch (Exception e) {
            log.error((Object)"Error when serveImage: ", e.fillInStackTrace());
            return Response.serverError().build();
        }
    }

    public String generateImageURI(Node file, String propertyName) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeLocation fielLocation = NodeLocation.make(file);
        String repository = fielLocation.getRepository();
        String workspaceName = fielLocation.getWorkspace();
        String nodeIdentifiler = file.isNodeType("mix:referenceable") ? file.getUUID() : file.getPath().replaceFirst("/", "");
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (propertyName == null) {
            if (!file.isNodeType("nt:file")) {
                throw new UnsupportedOperationException("The node isn't nt:file");
            }
            InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
            if (stream.available() == 0) {
                return null;
            }
            stream.close();
            builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?param=file");
            return builder.toString();
        }
        builder.append(portalName).append("/").append(restContextName).append("/").append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?param=").append(propertyName);
        return builder.toString();
    }

    @Deprecated
    public String generateURI(Node file) throws Exception {
        return this.generateImageURI(file, null);
    }

    @Deprecated
    public String generateURI(Node file, String propertyName) throws Exception {
        return this.generateImageURI(file, propertyName);
    }
}

