/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;

public class InitialWebContentPlugin
extends CreatePortalPlugin {
    private static Log log = ExoLogger.getLogger(CreatePortalPlugin.class);
    private InitParams initParams;
    private ConfigurationManager configurationManager;
    private RepositoryService repositoryService;
    private ExoCache artifactsCache;
    private LivePortalManagerService livePortalManagerService;

    public InitialWebContentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService, CacheService cacheService, LivePortalManagerService livePortalManagerService) throws Exception {
        super(initParams, configurationManager, repositoryService);
        this.initParams = initParams;
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
        this.artifactsCache = cacheService.getCacheInstance(((Object)((Object)this)).getClass().getName());
        this.livePortalManagerService = livePortalManagerService;
    }

    public void deployToPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        Iterator iterator = this.initParams.getObjectParamIterator();
        while (iterator.hasNext()) {
            ObjectParameter objectParameter = (ObjectParameter)iterator.next();
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)objectParameter.getObject();
            String sourcePath = deploymentDescriptor.getSourcePath();
            String xmlData = (String)this.artifactsCache.get((Serializable)((Object)sourcePath));
            if (xmlData == null) {
                InputStream stream = this.configurationManager.getInputStream(sourcePath);
                xmlData = IOUtil.getStreamContentAsString((InputStream)stream);
                this.artifactsCache.put((Serializable)((Object)sourcePath), (Object)xmlData);
            }
            ManageableRepository repository = this.repositoryService.getRepository(deploymentDescriptor.getTarget().getRepository());
            Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
            String targetPath = deploymentDescriptor.getTarget().getNodePath();
            String realTargetFolder = StringUtils.replace((String)targetPath, (String)"{portalName}", (String)portalName);
            InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
            session.importXML(realTargetFolder, inputStream, 0);
            session.save();
        }
        Node portalNode = this.livePortalManagerService.getLivePortal(sessionProvider, portalName);
        this.configure(portalNode, portalName);
        portalNode.getSession().save();
    }

    private void configure(Node targetNode, String portalName) throws Exception {
        String statement = "select * from nt:resource where jcr:path like '" + targetNode.getPath() + "/%' order by jcr:dateModified ASC";
        QueryManager queryManager = targetNode.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(statement, "sql");
        NodeIterator iterator = query.execute().getNodes();
        while (iterator.hasNext()) {
            String jcrData;
            Node ntResource = iterator.nextNode();
            String mimeType = ntResource.getProperty("jcr:mimeType").getString();
            if (!mimeType.startsWith("text") || !(jcrData = ntResource.getProperty("jcr:data").getString()).contains("{portalName}")) continue;
            String realData = StringUtils.replace((String)jcrData, (String)"{portalName}", (String)portalName);
            ntResource.setProperty("jcr:data", realData);
        }
    }
}

