/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterUserInfor;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UIManagerUsers;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UITabPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/newsletter/NewsletterManager/UIManagerUsers.gtmpl", events={@EventConfig(listeners={UnBanUserActionListener.class}), @EventConfig(listeners={BanUserActionListener.class}), @EventConfig(listeners={DeleteUserActionListener.class}), @EventConfig(listeners={AddAdministratorActionListener.class}), @EventConfig(listeners={DeleteAdministratorActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIManagerUsers
extends UITabPane {
    private String[] TITLE_ = new String[]{"Mail", "isBanned"};
    private String[] ACTIONS_ = new String[]{"BanUser", "UnBanUser", "DeleteUser"};
    private String[] MEMBER_TITLE_ = new String[]{"UserName", "FirstName", "LastName", "Email", "Role"};
    private String[] MEMBER_ACTIONS_ = new String[]{"AddAdministrator", "DeleteAdministrator"};
    private NewsletterManageUserHandler managerUserHandler = null;
    private String categoryName;
    private String subscriptionName;
    private String UIGRID_MANAGER_USERS = "UIManagerUsers";
    private String UIGRID_MANAGER_MODERATOR = "UIManagerModerator";
    public boolean isViewTab = false;
    private String[] permissions;

    public void getListPublicUser() {
        try {
            UIGrid uiGrid = (UIGrid)this.getChildById(this.UIGRID_MANAGER_USERS);
            ObjectPageList objPageList = new ObjectPageList(this.managerUserHandler.getUsers(Utils.getSessionProvider(), NewsLetterUtil.getPortalName(), this.categoryName, this.subscriptionName), 5);
            uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
        }
        catch (Exception ex) {
            Utils.createPopupMessage((UIContainer)this, (String)"UIManagerUsers.msg.get-list-users", null, (int)0);
        }
    }

    private void updateListUserInfor(UserHandler userHandler, List<NewsletterUserInfor> listUserInfor, List<String> listUser, String role) {
        for (String userName : listUser) {
            try {
                User user = userHandler.findUserByName(userName);
                NewsletterUserInfor userInfor = new NewsletterUserInfor();
                userInfor.setEmail(user.getEmail());
                userInfor.setFirstName(user.getFirstName());
                userInfor.setLastName(user.getLastName());
                userInfor.setUserName(user.getUserName());
                userInfor.setRole(role);
                listUserInfor.add(userInfor);
            }
            catch (Exception ex) {}
        }
    }

    private void addArrayToList(List<String> list1, String[] list2) {
        for (String str : list2) {
            if (list1.contains(str)) continue;
            list1.add(str);
        }
    }

    private List<String> getAllAccesPermissions() throws Exception {
        UserPortalConfigService userService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        Page page = userService.getPage(Util.getUIPortal().getSelectedNode().getPageReference());
        ArrayList<String> userGroupMembership = new ArrayList<String>();
        userGroupMembership.add(page.getOwnerId());
        this.addArrayToList(userGroupMembership, new String[]{page.getEditPermission()});
        this.addArrayToList(userGroupMembership, page.getAccessPermissions());
        return this.getAllUsersFromGroupMemebers(userGroupMembership);
    }

    private List<String> getAllEditPermission() throws Exception {
        ArrayList<String> userGroupMembership = new ArrayList<String>();
        userGroupMembership.add(((UserACL)PublicationUtil.getServices(UserACL.class)).getSuperUser());
        return this.getAllUsersFromGroupMemebers(userGroupMembership);
    }

    private List<String> getAllUsersFromGroupMemebers(List<String> userGroupMembership) throws Exception {
        ArrayList<String> users = new ArrayList<String>();
        if (userGroupMembership == null || userGroupMembership.size() <= 0) {
            return users;
        }
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        for (String str : userGroupMembership) {
            if ((str = str.trim()).indexOf("/") >= 0) {
                if (str.indexOf(":") >= 0) {
                    String[] array = str.split(":");
                    List userList = organizationService.getUserHandler().findUsersByGroup(array[1]).getAll();
                    if (array[0].length() > 1) {
                        block1: for (User user : userList) {
                            if (users.contains(user.getUserName())) continue;
                            Collection memberships = organizationService.getMembershipHandler().findMembershipsByUser(user.getUserName());
                            for (Membership member : memberships) {
                                if (!member.getMembershipType().equals(array[0])) continue;
                                users.add(user.getUserName());
                                continue block1;
                            }
                        }
                        continue;
                    }
                    if (array[0].charAt(0) != '*') continue;
                    for (User user : userList) {
                        if (users.contains(user.getUserName())) continue;
                        users.add(user.getUserName());
                    }
                    continue;
                }
                List userList = organizationService.getUserHandler().findUsersByGroup(str).getAll();
                for (User user : userList) {
                    if (users.contains(user.getUserName())) continue;
                    users.add(user.getUserName());
                }
                continue;
            }
            if (users.contains(str)) continue;
            users.add(str);
        }
        return users;
    }

    private void updateListUser() throws Exception {
        List listUserAccess = this.getAllAccesPermissions();
        List listUserEdit = this.getAllEditPermission();
        List<String> listModerator = new ArrayList();
        ArrayList listRedactor = new ArrayList();
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        NewsletterCategoryHandler categoryHandler = newsletterManagerService.getCategoryHandler();
        for (NewsletterCategoryConfig categoryConfig : categoryHandler.getListCategories(NewsLetterUtil.getPortalName(), Utils.getSessionProvider())) {
            for (String str : categoryConfig.getModerator().split(",")) {
                if (listModerator.contains(str)) continue;
                listModerator.add(str);
            }
        }
        listModerator = this.getAllUsersFromGroupMemebers(listModerator);
        listRedactor.addAll(this.getAllUsersFromGroupMemebers(newsletterManagerService.getSubscriptionHandler().getAllRedactor(NewsLetterUtil.getPortalName(), Utils.getSessionProvider())));
        for (String uId : this.managerUserHandler.getAllAdministrator(Utils.getSessionProvider(), NewsLetterUtil.getPortalName())) {
            if (listUserEdit.contains(uId)) continue;
            listUserEdit.add(uId);
        }
        listModerator.removeAll(listUserEdit);
        listRedactor.removeAll(listUserEdit);
        listRedactor.removeAll(listModerator);
        listUserAccess.removeAll(listUserEdit);
        listUserAccess.removeAll(listModerator);
        listUserAccess.removeAll(listRedactor);
        ArrayList userInfors = new ArrayList();
        UserHandler userHandler = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getUserHandler();
        this.updateListUserInfor(userHandler, userInfors, listUserEdit, this.permissions[0]);
        this.updateListUserInfor(userHandler, userInfors, listModerator, this.permissions[1]);
        this.updateListUserInfor(userHandler, userInfors, listRedactor, this.permissions[2]);
        this.updateListUserInfor(userHandler, userInfors, listUserAccess, this.permissions[3]);
        ObjectPageList objPageList = new ObjectPageList(userInfors, 5);
        UIGrid uiGrid = (UIGrid)this.getChildById(this.UIGRID_MANAGER_MODERATOR);
        UIPageIterator uiIterator_ = uiGrid.getUIPageIterator();
        uiIterator_.setPageList(null);
        uiIterator_.setPageList((PageList)objPageList);
        this.setSelectedTab(this.UIGRID_MANAGER_USERS);
    }

    public UIManagerUsers() throws Exception {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.managerUserHandler = newsletterManagerService.getManageUserHandler();
        this.permissions = new String[]{"Administrator", "Moderator", "Redactor", "User"};
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, this.UIGRID_MANAGER_USERS);
        uiGrid.getUIPageIterator().setId("UsersIterator");
        uiGrid.configure("Mail", this.TITLE_, this.ACTIONS_);
        this.addChild((UIComponent)uiGrid);
    }

    public void setInfor(String categoryName, String subscriptionName) {
        this.categoryName = categoryName;
        this.subscriptionName = subscriptionName;
        if (categoryName == null) {
            try {
                UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, this.UIGRID_MANAGER_MODERATOR);
                UIPageIterator uiIterator_ = uiGrid.getUIPageIterator();
                uiIterator_.setId("ModeratorsIterator");
                uiGrid.configure("UserName", this.MEMBER_TITLE_, this.MEMBER_ACTIONS_);
                this.addChild((UIComponent)uiGrid);
                this.isViewTab = true;
                this.setSelectedTab(this.UIGRID_MANAGER_USERS);
                this.updateListUser();
            }
            catch (Exception ex) {
                Utils.createPopupMessage((UIContainer)this, (String)"UIManagerUsers.msg.set-infor-users", null, (int)0);
            }
        }
    }

    static /* synthetic */ NewsletterManageUserHandler access$000(UIManagerUsers x0) {
        return x0.managerUserHandler;
    }

    static /* synthetic */ void access$100(UIManagerUsers x0) throws Exception {
        x0.updateListUser();
    }

    static /* synthetic */ String access$200(UIManagerUsers x0) {
        return x0.UIGRID_MANAGER_MODERATOR;
    }
}

