/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.Calendar;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterTemplateHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryDialogSelector;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.form.UIFormDateTimeInput;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UINewsletterEntryContainer
extends UIContainer {
    private NewsletterCategoryConfig categoryConfig;
    private String newsletterPath = null;
    private boolean isUpdated = false;

    public void setUpdated(boolean isUpdated) {
        this.isUpdated = isUpdated;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void setNewsletterInfor(String newsletterPath) throws Exception {
        this.newsletterPath = newsletterPath;
        this.init();
    }

    private void init() throws Exception {
        this.getChildren().clear();
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        UINewsletterEntryDialogSelector newsletterEntryDialogSelector = (UINewsletterEntryDialogSelector)this.addChild(UINewsletterEntryDialogSelector.class, null, null);
        UINewsletterEntryForm newsletterEntryForm = (UINewsletterEntryForm)this.createUIComponent(UINewsletterEntryForm.class, null, null);
        newsletterEntryForm.setRepositoryName(newsletterManagerService.getRepositoryName());
        newsletterEntryForm.setWorkspace(newsletterManagerService.getWorkspaceName());
        if (this.newsletterPath == null) {
            NewsletterTemplateHandler newsletterTemplateHandler = newsletterManagerService.getTemplateHandler();
            this.newsletterPath = newsletterTemplateHandler.getTemplate(Utils.getSessionProvider(), NewsLetterUtil.getPortalName(), this.categoryConfig, null).getPath();
            newsletterEntryForm.addNew(true);
        } else {
            UIFormDateTimeInput dateTimeInput = (UIFormDateTimeInput)newsletterEntryDialogSelector.getChild(UIFormDateTimeInput.class);
            dateTimeInput.getCalendar();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newsletterManagerService.getEntryHandler().getNewsletterEntryByPath(Utils.getSessionProvider(), this.newsletterPath).getNewsletterSentDate());
            dateTimeInput.setCalendar(calendar);
            newsletterEntryForm.addNew(false);
        }
        newsletterEntryForm.setNodePath(this.newsletterPath);
        newsletterEntryForm.getChildren().clear();
        newsletterEntryForm.resetProperties();
        this.addChild((UIComponent)newsletterEntryForm);
        this.newsletterPath = null;
    }

    public NewsletterCategoryConfig getCategoryConfig() {
        return this.categoryConfig;
    }

    public void setCategoryConfig(NewsletterCategoryConfig categoryConfig) throws Exception {
        this.categoryConfig = categoryConfig;
        this.init();
    }
}

