/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UICategories;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/newsletter/NewsletterManager/UICategories.gtmpl", events={@EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={AddSubcriptionActionListener.class}), @EventConfig(listeners={ManagerUsersActionListener.class}), @EventConfig(listeners={SelectSubscriptionActionListener.class})})
public class UICategories
extends UIContainer {
    NewsletterCategoryHandler categoryHandler = null;
    NewsletterSubscriptionHandler subscriptionHandler = null;
    NewsletterManageUserHandler userHandler = null;
    String portalName;

    public UICategories() throws Exception {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.categoryHandler = newsletterManagerService.getCategoryHandler();
        this.subscriptionHandler = newsletterManagerService.getSubscriptionHandler();
        this.userHandler = newsletterManagerService.getManageUserHandler();
        this.portalName = NewsLetterUtil.getPortalName();
    }

    private long getNumberOfWaitingNewsletter(String categoryName, String subscriptionName) {
        try {
            return this.subscriptionHandler.getNumberOfNewslettersWaiting(this.portalName, categoryName, subscriptionName, Utils.getSessionProvider((UIComponent)this));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    private int getNumberOfUser(String categoryName, String subscriptionName) {
        return this.userHandler.getQuantityUserBySubscription(this.portalName, categoryName, subscriptionName);
    }

    private List<NewsletterCategoryConfig> getListCategories() {
        List<Object> listCategories = new ArrayList<NewsletterCategoryConfig>();
        try {
            listCategories = this.categoryHandler.getListCategories(NewsLetterUtil.getPortalName(), Utils.getSessionProvider((UIComponent)this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listCategories;
    }

    private List<NewsletterSubscriptionConfig> getListSubscription(String categoryName) {
        List<Object> listSubscription = new ArrayList<NewsletterSubscriptionConfig>();
        try {
            listSubscription = this.subscriptionHandler.getSubscriptionsByCategory(NewsLetterUtil.getPortalName(), categoryName, Utils.getSessionProvider((UIComponent)this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listSubscription;
    }
}

