/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UICategories;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryManager;
import org.exoplatform.wcm.webui.newsletter.manager.UISubscriptions;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UINewsletterManagerPortlet
extends UIPortletApplication {
    private boolean isAdmin = false;
    private boolean isRenderUICategories = true;
    private boolean isRenderUISubscription = false;
    private boolean isRenderUINewsLetters = false;

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setRenderUIcategories() {
        this.isRenderUICategories = true;
        this.isRenderUISubscription = false;
        this.isRenderUINewsLetters = false;
    }

    public void setRenderUIsubscriptions() {
        this.isRenderUICategories = false;
        this.isRenderUISubscription = true;
        this.isRenderUINewsLetters = false;
    }

    public void setRenderUInewsLetter() {
        this.isRenderUICategories = false;
        this.isRenderUISubscription = false;
        this.isRenderUINewsLetters = true;
    }

    private List<String> getAllAdministrators() throws Exception {
        ArrayList<String> editPermission = new ArrayList<String>();
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        NewsletterManageUserHandler managerUserHandler = newsletterManagerService.getManageUserHandler();
        editPermission.addAll(managerUserHandler.getAllAdministrator(Utils.getSessionProvider(), NewsLetterUtil.getPortalName()));
        String supperUser = ((UserACL)PublicationUtil.getServices(UserACL.class)).getSuperUser();
        if (!editPermission.contains(supperUser) && supperUser.equals(NewsLetterUtil.getCurrentUser())) {
            editPermission.add(supperUser);
            SessionProvider sessionProvider = Utils.getSessionProvider();
            managerUserHandler.addAdministrator(sessionProvider, NewsLetterUtil.getPortalName(), supperUser);
        }
        return editPermission;
    }

    public UINewsletterManagerPortlet() throws Exception {
        try {
            List currentUsers = NewsLetterUtil.getAllGroupAndMembershipOfCurrentUser();
            List editPermission = this.getAllAdministrators();
            for (String str : currentUsers) {
                if (!editPermission.contains(str)) continue;
                this.isAdmin = true;
                break;
            }
        }
        catch (Exception ex) {
            this.isAdmin = false;
        }
        UICategories categories = (UICategories)((UICategories)this.addChild(UICategories.class, null, null)).setRendered(this.isRenderUICategories);
        categories.setAdmin(this.isAdmin);
        UISubscriptions subscriptions = (UISubscriptions)((UISubscriptions)this.addChild(UISubscriptions.class, null, null)).setRendered(this.isRenderUICategories);
        subscriptions.setAdmin(this.isAdmin);
        ((UINewsletterEntryManager)this.addChild(UINewsletterEntryManager.class, null, null)).setRendered(this.isRenderUINewsLetters);
        this.addChild(UIPopupContainer.class, null, null);
    }
}

