/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pclv;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pclv.UIPCLVContainer;
import org.exoplatform.wcm.webui.pclv.UIPCLVForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/ParameterizedContentListViewer/UIPCLVContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIPCLVContainer
extends UIContainer {
    private List<Node> listNode;
    private boolean isError;

    public boolean isError() {
        return this.isError;
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }

    public List<Node> getListNode() {
        return this.listNode;
    }

    public void setListNode(List<Node> listNode) {
        this.listNode = listNode;
    }

    private String getHeader() {
        String selectedPage;
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)portletRequestContext.getRequest();
        String requestURI = requestWrapper.getRequestURI();
        if (requestURI.endsWith(selectedPage = Util.getUIPortal().getSelectedNode().getUri())) {
            return null;
        }
        String[] param = requestURI.split("/");
        String header = param[param.length - 1];
        header = header.replaceAll("%20", " ");
        return header;
    }

    public void init() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)portletRequestContext.getRequest();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        UIPortal uiPortal = Util.getUIPortal();
        String portalURI = portalRequestContext.getPortalURI();
        String requestURI = requestWrapper.getRequestURI();
        String pageNodeSelected = uiPortal.getSelectedNode().getUri();
        String siteName = uiPortal.getOwner();
        String parameters = null;
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)requestURI, (String)portalURI.concat(pageNodeSelected + "/")), "UTF-8");
        }
        catch (Exception e) {
            Utils.createPopupMessage((org.exoplatform.webui.core.UIContainer)this, (String)"UIPCLVConfig.msg.decode", null, (int)0);
        }
        PortletRequest portletRequest = portletRequestContext.getRequest();
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        String preferenceRepository = portletPreferences.getValue("repository", "");
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        String treeName = null;
        treeName = parameters == null || parameters.trim().length() < 1 || parameters.indexOf("/") < 0 ? preferenceTreeName : parameters.substring(0, parameters.indexOf("/"));
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        Node treeNode = null;
        try {
            treeNode = taxonomyService.getTaxonomyTree(preferenceRepository, treeName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String categoryPath = parameters.substring(parameters.indexOf("/") + 1);
        if (treeName.equals(categoryPath)) {
            categoryPath = "";
        }
        Node categoryNode = null;
        ArrayList nodes = null;
        if (treeNode != null) {
            categoryNode = treeNode.getNode(categoryPath);
            nodes = this.getListSymlinkNode(portletPreferences, categoryNode.getPath());
        } else {
            nodes = this.getListSymlinkNode(portletPreferences, null);
        }
        if (nodes == null) {
            nodes = new ArrayList();
        }
        this.setListNode((List)nodes);
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        PaginatedNodeIterator paginatedNodeIterator = new PaginatedNodeIterator(nodes, itemsPerPage);
        this.getChildren().clear();
        UIPCLVForm parameterizedContentListViewer = (UIPCLVForm)this.addChild(UIPCLVForm.class, null, null);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        parameterizedContentListViewer.init(templatePath, resourceResolver, (PageList)paginatedNodeIterator);
        parameterizedContentListViewer.setContentColumn(portletPreferences.getValue("header", null));
        parameterizedContentListViewer.setShowLink(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        String autoDetect = portletPreferences.getValue("showAutoDetect", null);
        String currentHeader = this.getHeader();
        if (treeNode != null && "true".equals(autoDetect) && currentHeader != null) {
            parameterizedContentListViewer.setHeader(currentHeader);
        } else {
            parameterizedContentListViewer.setHeader(portletPreferences.getValue("header", null));
        }
        parameterizedContentListViewer.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        parameterizedContentListViewer.setShowReadmore(Boolean.parseBoolean(portletPreferences.getValue("showReadMore", null)));
        parameterizedContentListViewer.setAutoDetection(autoDetect);
        parameterizedContentListViewer.setShowRSSLink(portletPreferences.getValue("showRssLink", null));
        String workspace = portletPreferences.getValue("workspace", null);
        String server = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
        server = server.substring(0, server.indexOf(47, 8));
        parameterizedContentListViewer.setRssLink("/rest/rss/generate?repository=" + preferenceRepository + "&workspace=" + workspace + "&server=" + server + "&siteName=" + siteName + "&categoryPath=" + ("".equals(categoryPath) ? preferenceTreeName : preferenceTreeName + "/" + categoryPath));
    }

    public PortletPreferences getPortletPreference() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    public String getFormViewTemplatePath() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences references = portletRequestContext.getRequest().getPreferences();
        return references.getValue("formViewTemplatePath", null);
    }

    public ResourceResolver getTemplateResourceResolver() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences references = portletRequestContext.getRequest().getPreferences();
        String repository = references.getValue("repository", null);
        DMSConfiguration dmsConfiguration = (DMSConfiguration)Utils.getService(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig(repository).getSystemWorkspace();
        return new JCRResourceResolver(repository, workspace, "exo:templateFile");
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.init();
        super.processRender(context);
    }

    public void onRefresh(Event<UIPCLVForm> event) throws Exception {
        UIPCLVForm contentListPresentation = (UIPCLVForm)event.getSource();
        UIPCLVContainer uiParameterizedContentListontainer = (UIPCLVContainer)contentListPresentation.getParent();
        uiParameterizedContentListontainer.getChildren().clear();
        uiParameterizedContentListontainer.init();
    }

    private List<Node> getListSymlinkNode(PortletPreferences portletPreferences, String categoryPath) throws Exception {
        String repository = portletPreferences.getValue("repository", "");
        String worksapce = portletPreferences.getValue("workspace", "");
        String orderType = portletPreferences.getValue("orderType", "");
        String orderBy = portletPreferences.getValue("orderBy", "");
        if (categoryPath == null || categoryPath.trim().length() <= 0) {
            return null;
        }
        if ("".equals(orderType)) {
            orderType = "DESC";
        }
        if ("".equals(orderBy)) {
            orderBy = "exo:dateCreated";
        }
        String orderQuery = " ORDER BY ";
        orderQuery = orderQuery + orderBy + " " + orderType;
        RepositoryService repositoryService = (RepositoryService)Utils.getService(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        Session session = Utils.getSessionProvider((UIComponent)this).getSession(worksapce, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        StringBuffer sqlQuery = new StringBuffer("select * from exo:taxonomyLink where jcr:path LIKE '").append(categoryPath).append("/%'").append(" AND NOT jcr:path LIKE '").append(categoryPath).append("/%/%'").append(" " + orderQuery);
        Query query = queryManager.createQuery(sqlQuery.toString(), "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        ArrayList<Node> listNodes = new ArrayList<Node>();
        Node node = null;
        Node viewNode = null;
        while (iterator.hasNext()) {
            node = iterator.nextNode();
            viewNode = Utils.getNodeView((Node)node);
            if (viewNode == null) continue;
            listNodes.add(viewNode);
        }
        return listNodes;
    }
}

