/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pcv.UIPCVContainer;
import org.exoplatform.wcm.webui.pcv.UIPCVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ParameterizedContentViewer/UIPCVContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class}), @EventConfig(listeners={EditActionListener.class})})
public class UIPCVContainer
extends UIContainer {
    private boolean isDraftRevision = false;
    private boolean isObsoletedContent = false;
    private UIPCVPresentation uiContentViewer;
    private String repository;
    private boolean isPrint;
    public static final String PREFERENCE_REPOSITORY = "repository";
    private DateFormat dateFormatter = null;

    public UIPCVContainer() throws Exception {
        this.addChild(UIPCVPresentation.class, null, null);
        this.uiContentViewer = (UIPCVPresentation)this.getChild(UIPCVPresentation.class);
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.repository = porletRequestContext.getRequest().getPreferences().getValue(PREFERENCE_REPOSITORY, "");
        this.dateFormatter = new SimpleDateFormat();
        ((SimpleDateFormat)this.dateFormatter).applyPattern("dd.MM.yyyy '|' hh'h'mm");
    }

    public boolean isShowTitle() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue("showTitle", null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    private PortletPreferences getPortletPreferences() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = context.getRequest().getPreferences();
        return portletPreferences;
    }

    public String getTitle(Node node) throws Exception {
        String title = null;
        if (node.hasNode("jcr:content")) {
            Node content = node.getNode("jcr:content");
            if (content.hasProperty("dc:title")) {
                try {
                    title = content.getProperty("dc:title").getValues()[0].getString();
                }
                catch (Exception e) {
                    title = null;
                }
            }
        } else if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (title == null) {
            title = node.getName();
        }
        return title;
    }

    public boolean isShowDateCreated() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue("showDateCreated", null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    public boolean isShowBar() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue("showBar", null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getRepository() throws RepositoryException {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public Node getNode() throws Exception {
        String parameters = this.getRequestParameters();
        Node node = this.getNodebyPath(parameters);
        if (node == null) {
            node = this.getNodeByCategory(parameters);
        }
        if (node == null) {
            return null;
        }
        Node nodeView = Utils.getNodeView((Node)node);
        boolean isDocumentType = false;
        if (nodeView.isNodeType("nt:frozenNode")) {
            isDocumentType = true;
        }
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentTypes = templateService.getDocumentTemplates(this.getRepository());
        for (String documentType : documentTypes) {
            if (!nodeView.isNodeType(documentType)) continue;
            isDocumentType = true;
            break;
        }
        if (!isDocumentType) {
            return null;
        }
        if (this.hasChildren()) {
            this.removeChild(UIPCVContainer.class);
        }
        if (nodeView != null && nodeView.isNodeType("nt:frozenNode")) {
            String nodeUUID = nodeView.getProperty("jcr:frozenUuid").getString();
            this.uiContentViewer.setOrginalNode(nodeView.getSession().getNodeByUUID(nodeUUID));
            this.uiContentViewer.setNode(nodeView);
        } else {
            if (nodeView == null) {
                return null;
            }
            this.uiContentViewer.setOrginalNode(nodeView);
            this.uiContentViewer.setNode(nodeView);
        }
        this.uiContentViewer.setRepository(this.getRepository());
        this.uiContentViewer.setWorkspace(nodeView.getSession().getWorkspace().getName());
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)porletRequestContext.getRequest();
        this.isPrint = request.getQueryString() == null ? false : request.getQueryString().endsWith("isPrint=true");
        return nodeView;
    }

    private String getRequestParameters() {
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        UIPortal uiPortal = Util.getUIPortal();
        String portalURI = portalRequestContext.getPortalURI();
        String requestURI = requestWrapper.getRequestURI();
        String pageNodeSelected = uiPortal.getSelectedNode().getUri();
        String parameters = null;
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)requestURI, (String)portalURI.concat(pageNodeSelected + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        if (!parameters.matches("(.*)/(.*)")) {
            return null;
        }
        return parameters;
    }

    private Node getNodebyPath(String parameters) throws Exception {
        if (parameters == null) {
            return null;
        }
        ManageableRepository manageableRepository = null;
        String[] params = parameters.split("/");
        String repository = params[0];
        String workspace = params[1];
        try {
            RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            manageableRepository = repositoryService.getRepository(repository);
        }
        catch (Exception e) {
            return null;
        }
        String nodeIdentifier = null;
        Node currentNode = null;
        Session session = Utils.getSessionProvider((UIComponent)this).getSession(workspace, manageableRepository);
        if (params.length > 2) {
            StringBuffer identifier = new StringBuffer();
            for (int i = 2; i < params.length; ++i) {
                identifier.append("/").append(params[i]);
            }
            nodeIdentifier = identifier.toString();
            boolean isUUID = false;
            try {
                currentNode = (Node)session.getItem(nodeIdentifier);
            }
            catch (Exception e) {
                isUUID = true;
            }
            if (isUUID) {
                try {
                    String uuid = params[params.length - 1];
                    currentNode = session.getNodeByUUID(uuid);
                }
                catch (ItemNotFoundException exc) {
                    return null;
                }
                catch (AccessDeniedException ex) {
                    return null;
                }
            }
        } else if (params.length == 2) {
            currentNode = session.getRootNode();
        }
        return currentNode;
    }

    private Node getNodeByCategory(String parameters) throws Exception {
        if (parameters == null) {
            return null;
        }
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        String[] params = parameters.split("/");
        try {
            Node taxonomyTree = taxonomyService.getTaxonomyTree(this.getRepository(), params[0]);
            String symLinkPath = parameters.substring(parameters.indexOf("/") + 1);
            Node symLink = taxonomyTree.getNode(symLinkPath);
            return taxonomyTree.getSession().getNodeByUUID(symLink.getProperty("exo:uuid").getString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void renderErrorMessage(WebuiRequestContext context, String keyBundle) throws Exception {
        Writer writer = context.getWriter();
        String message = context.getApplicationResourceBundle().getString(keyBundle);
        writer.write("<div style=\"height: 55px; font-size: 13px; text-align: center; padding-top: 10px;\">");
        writer.write("<span>");
        writer.write(message);
        writer.write("</span>");
        writer.write("</div>");
        writer.close();
    }

    public boolean getIsPrint() {
        return this.isPrint;
    }

    public void setIsPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public boolean isDraftRevision() {
        return this.isDraftRevision;
    }

    public void setDraftRevision(boolean isDraftRevision) {
        this.isDraftRevision = isDraftRevision;
    }

    public boolean isObsoletedContent() {
        return this.isObsoletedContent;
    }

    public void setObsoletedContent(boolean isObsoletedContent) {
        this.isObsoletedContent = isObsoletedContent;
    }
}

