/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/SingleContentViewer/UIPresentationContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIPresentationContainer
extends UIContainer {
    public UIPresentationContainer() throws Exception {
        this.addChild(UIPresentation.class, null, null);
    }

    public String getTitle(Node node) throws Exception {
        String title = null;
        if (node.hasNode("jcr:content")) {
            Node content = node.getNode("jcr:content");
            if (content.hasProperty("dc:title")) {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
        } else if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (title == null) {
            title = node.getName();
        }
        return title;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return new SimpleDateFormat("dd.MM.yyyy '|' hh'h'mm").format(calendar.getTime());
        }
        return null;
    }

    public String getPrintUrl() {
        UISingleContentViewerPortlet scvPortlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
        NodeLocation viewNodeLocation = NodeLocation.make((Node)scvPortlet.getNodeView());
        String portalURI = Util.getPortalRequestContext().getPortalURI();
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        String printPageUrl = wcmConfigurationService.getRuntimeContextParam("printViewerPage");
        String printUrl = portalURI + printPageUrl + "/" + viewNodeLocation.getRepository() + "/" + viewNodeLocation.getWorkspace() + viewNodeLocation.getPath() + "?isPrint=true";
        return printUrl;
    }
}

