/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.administration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.wcm.webui.administration.UISiteAdminToolbar;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/SiteAdministration/UISiteAdminToolBar.gtmpl", events={@EventConfig(listeners={AddPageActionListener.class}), @EventConfig(listeners={EditPageActionListener.class}), @EventConfig(listeners={EditPortalActionListener.class}), @EventConfig(listeners={CreatePortalActionListener.class}), @EventConfig(listeners={ChangePortalActionListener.class}), @EventConfig(listeners={SkinSettingsActionListener.class}), @EventConfig(listeners={LanguageSettingsActionListener.class}), @EventConfig(listeners={AccountSettingsActionListener.class}), @EventConfig(listeners={AddContentActionListener.class}), @EventConfig(listeners={BrowsePortalActionListener.class}), @EventConfig(listeners={BrowsePageActionListener.class}), @EventConfig(listeners={EditPageAndNavigationActionListener.class}), @EventConfig(listeners={ChangePageActionListener.class}), @EventConfig(listeners={TurnOnQuickEditActionListener.class}), @EventConfig(listeners={TurnOffQuickEditActionListener.class})})
public class UISiteAdminToolbar
extends UIContainer {
    public static final String MESSAGE = "UISiteAdminToolbar.msg.not-permission";
    public static final String TURN_ON_QUICK_EDIT = "isTurnOn";
    public static final int ADMIN = 2;
    public static final int EDITOR = 1;
    public static final int REDACTOR = 0;
    public static final int VISITOR = -1;
    private boolean hasGroupNavigations = false;
    private List<PageNavigation> groupNavigations = null;
    private List<PageNavigation> currentSiteNavigations = null;
    private int role = -1;

    public UISiteAdminToolbar() throws Exception {
        this.refresh();
    }

    protected void setRole() throws Exception {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getApplicationComponent(IdentityRegistry.class);
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        Identity identity = identityRegistry.getIdentity(userId);
        String editorMembershipType = userACL.getMakableMT();
        List accessControlWorkspaceGroups = userACL.getAccessControlWorkspaceGroups();
        String editSitePermission = Util.getUIPortal().getEditPermission();
        String redactorMembershipType = wcmConfigurationService.getRuntimeContextParam("newsletterManageMembership").split(":")[0];
        if (userACL.getSuperUser().equals(userId)) {
            this.role = 2;
            return;
        }
        if (userACL.hasAccessControlWorkspacePermission(userId) && userACL.hasCreatePortalPermission(userId)) {
            this.role = 2;
            return;
        }
        MembershipEntry editorEntry = null;
        for (String membership : accessControlWorkspaceGroups) {
            editorEntry = MembershipEntry.parse((String)membership);
            if (!editorEntry.getMembershipType().equals(editorMembershipType) && !editorEntry.getMembershipType().equals("*") || !identity.isMemberOf(editorEntry)) continue;
            MembershipEntry editEntry = MembershipEntry.parse((String)editSitePermission);
            if ("*".equals(editEntry.getMembershipType())) {
                editEntry = MembershipEntry.parse((String)(editorMembershipType + ":" + editEntry.getGroup()));
            }
            if (!identity.isMemberOf(editEntry)) continue;
            this.role = 1;
            return;
        }
        MembershipEntry redactorEntry = MembershipEntry.parse((String)editSitePermission);
        if ((redactorEntry.getMembershipType().equals(redactorMembershipType) || redactorEntry.getMembershipType().equals("*")) && identity.isMemberOf(redactorEntry)) {
            this.role = 0;
            return;
        }
        this.role = -1;
    }

    public int getRole() throws Exception {
        return this.role;
    }

    public void refresh() throws Exception {
        this.setRole();
        this.buildNavigations();
    }

    public void changeNavigationsLanguage(String language) {
        ResourceBundle res;
        LocaleConfig localeConfig = ((LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class)).getLocaleConfig(language);
        for (PageNavigation nav : this.groupNavigations) {
            res = localeConfig.getNavigationResourceBundle(nav.getOwnerType(), nav.getOwnerId());
            for (PageNode node : nav.getNodes()) {
                this.resolveLabel(res, node);
            }
        }
        for (PageNavigation nav : this.currentSiteNavigations) {
            res = localeConfig.getNavigationResourceBundle(nav.getOwnerType(), nav.getOwnerId());
            for (PageNode node : nav.getNodes()) {
                this.resolveLabel(res, node);
            }
        }
    }

    private void resolveLabel(ResourceBundle res, PageNode node) {
        node.setResolvedLabel(res);
        if (node.getChildren() == null) {
            return;
        }
        for (PageNode childNode : node.getChildren()) {
            this.resolveLabel(res, childNode);
        }
    }

    public boolean isShowWorkspaceArea() throws Exception {
        PortletRequestContext context;
        String userId;
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        return userACL.hasAccessControlWorkspacePermission(userId = (context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRemoteUser());
    }

    public String getCurrentPortalURI() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String portalContextURI = portalRequestContext.getPortalURI();
        HttpServletRequest servletRequest = portalRequestContext.getRequest();
        String baseURI = servletRequest.getScheme() + "://" + servletRequest.getServerName() + ":" + servletRequest.getServerPort() + portalContextURI.substring(0, portalContextURI.length() - 1);
        return baseURI;
    }

    public List<String> getAllPortals() throws Exception {
        ArrayList<String> portals = new ArrayList<String>();
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        PageList pageList = dataStorage.find(query);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        for (PortalConfig pConfig : pageList.getAll()) {
            if (!userACL.hasPermission(pConfig, userId)) continue;
            portals.add(pConfig.getName());
        }
        String currentPortal = Util.getUIPortal().getName();
        portals.remove(currentPortal);
        Collections.sort(portals, new /* Unavailable Anonymous Inner Class!! */);
        portals.add(currentPortal);
        return portals;
    }

    public boolean hasGroupNavigations() {
        return this.hasGroupNavigations;
    }

    private void buildNavigations() throws Exception {
        this.hasGroupNavigations = false;
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        List allNavigations = Util.getUIPortal().getNavigations();
        this.groupNavigations = new ArrayList();
        this.currentSiteNavigations = new ArrayList();
        for (PageNavigation navigation : allNavigations) {
            if (navigation.getOwnerType().equals("group")) {
                this.groupNavigations.add(PageNavigationUtils.filter((PageNavigation)navigation, (String)remoteUser));
                this.hasGroupNavigations = true;
            }
            if (!navigation.getOwnerType().equals("portal")) continue;
            this.currentSiteNavigations.add(PageNavigationUtils.filter((PageNavigation)navigation, (String)remoteUser));
        }
    }

    public List<PageNavigation> getCurrentSiteNavigations() throws Exception {
        return this.currentSiteNavigations;
    }

    public List<PageNavigation> getGroupNavigations() throws Exception {
        return this.groupNavigations;
    }
}

