/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.Calendar;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVFolderMode;
import org.exoplatform.wcm.webui.clv.UICLVManualMode;
import org.exoplatform.wcm.webui.clv.config.UICLVConfig;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UICLVPortlet
extends UIPortletApplication {
    private PortletMode mode = PortletMode.VIEW;
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "workspace";
    public static final String ITEMS_PER_PAGE = "itemsPerPage";
    public static final String FOLDER_PATH = "folderPath";
    public static final String HEADER = "header";
    public static final String FORM_VIEW_TEMPLATE_PATH = "formViewTemplatePath";
    public static final String PAGINATOR_TEMPlATE_PATH = "paginatorTemplatePath";
    public static final String SHOW_REFRESH_BUTTON = "showRefreshButton";
    public static final String SHOW_THUMBNAILS_VIEW = "showThumbnailsView";
    public static final String SHOW_TITLE = "showTitle";
    public static final String SHOW_SUMMARY = "showSummary";
    public static final String SHOW_DATE_CREATED = "showDateCreated";
    public static final String SHOW_HEADER = "showHeader";
    public static final String SHOW_READMORE = "showReadmore";
    public static final String SHOW_LINK = "showLink";
    public static final String CONTENT_SOURCE = "source";
    public static final String VIEWER_MODE = "mode";
    public static final String ORDER_BY = "orderBy";
    public static final String ORDER_TYPE = "orderType";
    public static final String CONTENT_LIST = "contents";
    public static final String BASE_PATH = "basePath";

    public UICLVPortlet() throws Exception {
        this.activateMode(this.mode);
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletMode newMode = pContext.getApplicationMode();
        if (!this.mode.equals((Object)newMode)) {
            this.activateMode(newMode);
            this.mode = newMode;
        }
        super.processRender(app, context);
    }

    private void activateMode(PortletMode mode) throws Exception {
        this.getChildren().clear();
        Calendar lCDateTime = Calendar.getInstance();
        this.addChild(UIPopupContainer.class, null, "UIPopupContainer-" + lCDateTime.getTimeInMillis());
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = context.getRequest().getPreferences();
        String viewerMode = preferences.getValue(VIEWER_MODE, null);
        if (PortletMode.VIEW.equals((Object)mode)) {
            if (viewerMode == null) {
                viewerMode = "AutoViewerMode";
            }
            if (viewerMode.equals("AutoViewerMode")) {
                UICLVFolderMode uiFolderViewer = (UICLVFolderMode)this.addChild(UICLVFolderMode.class, null, UIPortletApplication.VIEW_MODE + "-" + lCDateTime.getTimeInMillis());
                uiFolderViewer.init();
            } else if (viewerMode.equals("ManualViewerMode")) {
                UICLVManualMode uiCorrectContentsViewer = (UICLVManualMode)this.addChild(UICLVManualMode.class, null, UIPortletApplication.VIEW_MODE + "-" + lCDateTime.getTimeInMillis());
                uiCorrectContentsViewer.init();
            }
        } else if (PortletMode.EDIT.equals((Object)mode)) {
            this.addChild(UICLVConfig.class, null, null);
        }
    }

    public boolean canEditPortlet() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String userId = context.getRemoteUser();
        return Utils.canEditCurrentPortal((String)userId);
    }

    public static String[] getContentsByPreference() {
        try {
            PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences preferences = context.getRequest().getPreferences();
            return preferences.getValues(CONTENT_LIST, null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

