/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.component.action.CommentActionComponent;
import org.exoplatform.wcm.webui.pcv.UIPCVContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class)
public class UIPCVPresentation
extends UIBaseNodePresentation {
    private NodeLocation contentNodeLocation;
    private NodeLocation originalNodeLocation;
    private JCRResourceResolver resourceResolver;
    private String repository;
    private String workspace;
    public static final String CONTENT_NOT_FOUND_EXC = "UIMessageBoard.msg.content-not-found";
    public static final String ACCESS_CONTROL_EXC = "UIMessageBoard.msg.access-control-exc";
    public static final String CONTENT_UNSUPPORT_EXC = "UIMessageBoard.msg.content-unsupport-exc";
    public static final String CONTENT_NOT_PRINTED = "UIMessageBoard.msg.content-invisible";
    public static final String OBSOLETE_CONTENT = "UIMessageBoard.msg.content-obsolete";
    public static final String PARAMETER_REGX = "(.*)/(.*)";

    public Node getNode() throws Exception {
        return Utils.getViewableNodeByComposer((String)this.contentNodeLocation.getRepository(), (String)this.contentNodeLocation.getWorkspace(), (String)this.contentNodeLocation.getPath());
    }

    public Node getOriginalNode() throws Exception {
        return Utils.getViewableNodeByComposer((String)this.originalNodeLocation.getRepository(), (String)this.originalNodeLocation.getWorkspace(), (String)this.originalNodeLocation.getPath(), (String)"base");
    }

    public void setOriginalNode(Node originalNode) {
        this.originalNodeLocation = NodeLocation.make((Node)originalNode);
    }

    public String getRepositoryName() throws Exception {
        return this.repository;
    }

    public String getWorkspaceName() throws Exception {
        return this.workspace;
    }

    public String getTemplatePath() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getTemplatePath(this.getOriginalNode(), false);
    }

    public String getTemplate() {
        try {
            return this.getTemplatePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String workspace = dmsConfiguration.getConfig(this.repository).getSystemWorkspace();
            this.resourceResolver = new JCRResourceResolver(this.repository, workspace, "exo:templateFile");
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UIMessageBoard.msg.get-template-resource", null, (int)0);
        }
        return this.resourceResolver;
    }

    public String getNodeType() throws Exception {
        return this.getOriginalNode().getPrimaryNodeType().getName();
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public void setNode(Node node) {
        this.contentNodeLocation = NodeLocation.make((Node)node);
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public UIComponent getCommentComponent() {
        try {
            Node node = this.getOriginalNode();
            if (!PermissionUtil.canAddNode((Node)node) || !node.isNodeType("mix:commentable") || !node.isCheckedOut() || Utils.nodeIsLocked((Node)node)) {
                return null;
            }
            this.removeChild(CommentActionComponent.class);
            UIComponent uicomponent = this.addChild(CommentActionComponent.class, null, "DocumentInfoCommentComponent");
            return uicomponent;
        }
        catch (Exception e) {
            return null;
        }
    }

    public UIComponent getRemoveAttach() throws Exception {
        if ("Live".equals(Utils.getCurrentMode())) {
            return null;
        }
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "DocumentInfoRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPCVContainer.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        Node node = this.getOriginalNode();
        if (!PermissionUtil.canRemoveNode((Node)node) || !node.isNodeType("mix:commentable") || !node.isCheckedOut() || Utils.nodeIsLocked((Node)node)) {
            return null;
        }
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "DocumentInfoRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPCVContainer.class));
        return uicomponent;
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.getOriginalNode(), this.getLanguage());
    }
}

