/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.dialog.permission;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UIGroupMemberSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.dialog.UIContentDialogForm;
import org.exoplatform.wcm.webui.dialog.permission.UIPermissionConfig;
import org.exoplatform.wcm.webui.selector.account.UIUserContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/dialog/permission/UIPermissionManager.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionManagerGrid.msg.confirm-delete-permission"), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ClearActionListener.class}), @EventConfig(listeners={SelectUserActionListener.class}), @EventConfig(listeners={SelectMemberActionListener.class}), @EventConfig(listeners={AddAnyActionListener.class})})
public class UIPermissionManager
extends UIForm
implements UISelectable {
    public static final String PERMISSION_MANAGER_GRID = "UIPermissionManagerGrid";
    public static final String PERMISSION_INPUT_SET = "UIPermissionInputSetWithAction";
    public static final String PERMISSION_STRING_INPUT = "UIPermissionStringInput";
    public static final String ACCESSIBLE_CHECKBOX_INPUT = "UIAccessibleCheckboxInput";
    public static final String EDITABLE_CHECKBOX_INPUT = "UIEditableCheckboxInput";
    public static final String USER_SELECTOR_POPUP_WINDOW = "UIUserSelectorPopupWindow";
    public static final String GROUP_SELECTOR_POPUP_WINDOW = "UIGroupSelectorPopupWindow";
    private String popupId;

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public UIPermissionManager() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, PERMISSION_MANAGER_GRID);
        uiGrid.setLabel(PERMISSION_MANAGER_GRID);
        uiGrid.configure("owner", new String[]{"owner", "accessible", "editable"}, new String[]{"Edit", "Delete"});
        this.addChild((UIComponent)uiGrid);
        UIFormInputSetWithAction permissionInputSet = new UIFormInputSetWithAction(PERMISSION_INPUT_SET);
        UIFormStringInput formStringInput = new UIFormStringInput(PERMISSION_STRING_INPUT, PERMISSION_STRING_INPUT, null);
        formStringInput.setEditable(false);
        permissionInputSet.addChild((UIComponent)formStringInput);
        permissionInputSet.setActionInfo(PERMISSION_STRING_INPUT, new String[]{"SelectUser", "SelectMember", "AddAny"});
        permissionInputSet.showActionInfo(true);
        this.addChild((UIComponent)permissionInputSet);
        this.addChild((UIComponent)new UIFormCheckBoxInput(ACCESSIBLE_CHECKBOX_INPUT, ACCESSIBLE_CHECKBOX_INPUT, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput(EDITABLE_CHECKBOX_INPUT, EDITABLE_CHECKBOX_INPUT, null));
        this.setActions(new String[]{"Save", "Clear"});
    }

    public void updateGrid() throws Exception {
        UIContentDialogForm contentDialogForm = (UIContentDialogForm)((UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class)).getChild(UIContentDialogForm.class);
        NodeLocation webcontentNodeLocation = contentDialogForm.getWebcontentNodeLocation();
        Node node = NodeLocation.getNodeByLocation((NodeLocation)webcontentNodeLocation);
        ExtendedNode webcontent = (ExtendedNode)node;
        ArrayList<UIPermissionConfig> permissionConfigs = new ArrayList<UIPermissionConfig>();
        HashMap permissionMap = new HashMap();
        List accessControlEntries = webcontent.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : accessControlEntries) {
            String identity = accessControlEntry.getIdentity();
            String permission = accessControlEntry.getPermission();
            ArrayList<String> currentPermissions = (ArrayList<String>)permissionMap.get(identity);
            if (!permissionMap.containsKey(identity)) {
                permissionMap.put(identity, null);
            }
            if (currentPermissions == null) {
                currentPermissions = new ArrayList<String>();
            }
            if (!currentPermissions.contains(permission)) {
                currentPermissions.add(permission);
            }
            permissionMap.put(identity, currentPermissions);
        }
        String owner = SystemIdentity.SYSTEM;
        if (webcontent.hasProperty("exo:owner")) {
            owner = webcontent.getProperty("exo:owner").getString();
        }
        UIPermissionConfig permissionConfig = new UIPermissionConfig();
        if (!permissionMap.containsKey(owner)) {
            permissionConfig.setOwner(owner);
            permissionConfig.setAccessible(true);
            permissionConfig.setEditable(true);
            permissionConfigs.add(permissionConfig);
        }
        for (String identity : permissionMap.keySet()) {
            List userPermissions = (List)permissionMap.get(identity);
            UIPermissionConfig permBean = new UIPermissionConfig();
            permBean.setOwner(identity);
            int numberPermission = 0;
            for (String p : PermissionType.ALL) {
                if (!userPermissions.contains(p)) break;
                ++numberPermission;
            }
            if (numberPermission == PermissionType.ALL.length) {
                permBean.setEditable(true);
                permBean.setAccessible(true);
            } else {
                permBean.setAccessible(true);
            }
            permissionConfigs.add(permBean);
        }
        ObjectPageList objPageList = new ObjectPageList(permissionConfigs, 10);
        UIGrid uiGrid = (UIGrid)this.getChildById(PERMISSION_MANAGER_GRID);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        UIFormInputSetWithAction permissionInputSet = (UIFormInputSetWithAction)this.getChildById(PERMISSION_INPUT_SET);
        permissionInputSet.getUIStringInput(PERMISSION_STRING_INPUT).setValue((Object)value.toString());
        Utils.closePopupWindow((UIContainer)this, this.popupId);
    }

    private boolean hasChangePermissionRight(ExtendedNode node) throws Exception {
        try {
            node.checkPermission("add_node");
            node.checkPermission("remove");
            node.checkPermission("set_property");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddAnyActionListener
    extends EventListener<UIPermissionManager> {
        public void execute(Event<UIPermissionManager> event) throws Exception {
            UIPermissionManager permissionManager = (UIPermissionManager)((Object)event.getSource());
            UIFormInputSetWithAction permisionInputSet = (UIFormInputSetWithAction)permissionManager.getChildById(UIPermissionManager.PERMISSION_INPUT_SET);
            ((UIFormStringInput)permisionInputSet.getChildById(UIPermissionManager.PERMISSION_STRING_INPUT)).setValue((Object)SystemIdentity.ANY);
            permissionManager.getUIFormCheckBoxInput(UIPermissionManager.ACCESSIBLE_CHECKBOX_INPUT).setChecked(true);
            permissionManager.getUIFormCheckBoxInput(UIPermissionManager.EDITABLE_CHECKBOX_INPUT).setChecked(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectMemberActionListener
    extends EventListener<UIPermissionManager> {
        public void execute(Event<UIPermissionManager> event) throws Exception {
            UIPermissionManager permissionManager = (UIPermissionManager)((Object)event.getSource());
            UIGroupMemberSelector groupContainer = (UIGroupMemberSelector)permissionManager.createUIComponent(UIGroupMemberSelector.class, null, null);
            groupContainer.setShowAnyPermission(false);
            groupContainer.setSourceComponent((UIComponent)permissionManager, new String[]{UIPermissionManager.PERMISSION_STRING_INPUT});
            Utils.createPopupWindow((UIContainer)permissionManager, (UIComponent)groupContainer, UIPermissionManager.GROUP_SELECTOR_POPUP_WINDOW, 600, 400);
            permissionManager.setPopupId(UIPermissionManager.GROUP_SELECTOR_POPUP_WINDOW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectUserActionListener
    extends EventListener<UIPermissionManager> {
        public void execute(Event<UIPermissionManager> event) throws Exception {
            UIPermissionManager permissionManager = (UIPermissionManager)((Object)event.getSource());
            UIUserContainer userContainer = (UIUserContainer)permissionManager.createUIComponent(UIUserContainer.class, null, null);
            userContainer.setSelectable(permissionManager);
            userContainer.setSourceComponent(UIPermissionManager.PERMISSION_STRING_INPUT);
            Utils.createPopupWindow((UIContainer)permissionManager, (UIComponent)userContainer, UIPermissionManager.USER_SELECTOR_POPUP_WINDOW, 740, 320);
            permissionManager.setPopupId(UIPermissionManager.USER_SELECTOR_POPUP_WINDOW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearActionListener
    extends EventListener<UIPermissionManager> {
        public void execute(Event<UIPermissionManager> event) throws Exception {
            UIPermissionManager permissionManager = (UIPermissionManager)((Object)event.getSource());
            UIFormInputSetWithAction permissionInputSet = (UIFormInputSetWithAction)permissionManager.getChildById(UIPermissionManager.PERMISSION_INPUT_SET);
            ((UIFormStringInput)permissionInputSet.getChildById(UIPermissionManager.PERMISSION_STRING_INPUT)).setValue((Object)"");
            permissionManager.getUIFormCheckBoxInput(UIPermissionManager.ACCESSIBLE_CHECKBOX_INPUT).setChecked(false);
            permissionManager.getUIFormCheckBoxInput(UIPermissionManager.EDITABLE_CHECKBOX_INPUT).setChecked(false);
            permissionManager.setActions(new String[]{"Save", "Clear"});
            permissionInputSet.setActionInfo(UIPermissionManager.PERMISSION_STRING_INPUT, new String[]{"SelectUser", "SelectMember", "AddAny"});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPermissionManager> {
        public void execute(Event<UIPermissionManager> event) throws Exception {
            UIPermissionManager permissionManager = (UIPermissionManager)((Object)event.getSource());
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)((UIPopupContainer)permissionManager.getAncestorOfType(UIPopupContainer.class)).getChild(UIContentDialogForm.class);
            NodeLocation webcontentNodeLocation = contentDialogForm.getWebcontentNodeLocation();
            Node node = NodeLocation.getNodeByLocation((NodeLocation)webcontentNodeLocation);
            ExtendedNode webcontent = (ExtendedNode)node;
            Session session = webcontent.getSession();
            UIFormInputSetWithAction formInputSet = (UIFormInputSetWithAction)permissionManager.getChildById(UIPermissionManager.PERMISSION_INPUT_SET);
            String identity = (String)((UIFormStringInput)formInputSet.getChildById(UIPermissionManager.PERMISSION_STRING_INPUT)).getValue();
            ArrayList<String> permsList = new ArrayList<String>();
            if (!webcontent.isCheckedOut()) {
                Utils.createPopupMessage((UIContainer)permissionManager, "UIPermissionManagerGrid.msg.node-checkedin", null, 1);
                return;
            }
            if (permissionManager.getUIFormCheckBoxInput(UIPermissionManager.ACCESSIBLE_CHECKBOX_INPUT).isChecked()) {
                permsList.clear();
                permsList.add("read");
            }
            if (permissionManager.getUIFormCheckBoxInput(UIPermissionManager.EDITABLE_CHECKBOX_INPUT).isChecked()) {
                permsList.clear();
                for (String perm : PermissionType.ALL) {
                    permsList.add(perm);
                }
            }
            if (identity == null || identity.trim().length() == 0) {
                Utils.createPopupMessage((UIContainer)permissionManager, "UIPermissionManagerGrid.msg.userOrGroup-required", null, 1);
                return;
            }
            if (permsList.size() == 0) {
                Utils.createPopupMessage((UIContainer)permissionManager, "UIPermissionManagerGrid.msg.checkbox-require", null, 1);
                return;
            }
            String[] permsArray = permsList.toArray(new String[permsList.size()]);
            if (webcontent.canAddMixin("exo:privilegeable")) {
                webcontent.addMixin("exo:privilegeable");
                webcontent.setPermission(webcontent.getProperty("exo:owner").getString(), PermissionType.ALL);
            }
            try {
                webcontent.setPermission(identity, permsArray);
            }
            catch (AccessControlException e) {
                Object[] args = new Object[]{webcontent.getPath()};
                Utils.createPopupMessage((UIContainer)permissionManager, "UIPermissionManagerGrid.msg.node-locked", args, 1);
                return;
            }
            session.save();
            permissionManager.updateGrid();
            UIFormInputSetWithAction permissionInputSet = (UIFormInputSetWithAction)permissionManager.getChildById(UIPermissionManager.PERMISSION_INPUT_SET);
            ((UIFormStringInput)permissionInputSet.getChildById(UIPermissionManager.PERMISSION_STRING_INPUT)).setValue((Object)"");
            permissionManager.getUIFormCheckBoxInput(UIPermissionManager.ACCESSIBLE_CHECKBOX_INPUT).setChecked(false);
            permissionManager.getUIFormCheckBoxInput(UIPermissionManager.EDITABLE_CHECKBOX_INPUT).setChecked(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIPermissionManager> {
        public void execute(Event<UIPermissionManager> event) throws Exception {
            UIPermissionManager permissionManager = (UIPermissionManager)((Object)event.getSource());
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)((UIPopupContainer)permissionManager.getAncestorOfType(UIPopupContainer.class)).getChild(UIContentDialogForm.class);
            NodeLocation webcontentNodeLocation = contentDialogForm.getWebcontentNodeLocation();
            Node node = NodeLocation.getNodeByLocation((NodeLocation)webcontentNodeLocation);
            ExtendedNode webcontent = (ExtendedNode)node;
            String name = event.getRequestContext().getRequestParameter("objectId");
            UIFormInputSetWithAction permissionInputSet = (UIFormInputSetWithAction)permissionManager.getChildById(UIPermissionManager.PERMISSION_INPUT_SET);
            permissionInputSet.getUIStringInput(UIPermissionManager.PERMISSION_STRING_INPUT).setValue((Object)name);
            String owner = node.getProperty("exo:owner").getString();
            if (name.equals(owner)) {
                permissionManager.getUIFormCheckBoxInput(UIPermissionManager.ACCESSIBLE_CHECKBOX_INPUT).setChecked(true);
                permissionManager.getUIFormCheckBoxInput(UIPermissionManager.EDITABLE_CHECKBOX_INPUT).setChecked(true);
                permissionManager.setActions(new String[]{"Clear"});
                permissionInputSet.setActionInfo(UIPermissionManager.PERMISSION_STRING_INPUT, null);
            } else {
                List permsList = webcontent.getACL().getPermissionEntries();
                StringBuilder userPermission = new StringBuilder();
                for (AccessControlEntry accessControlEntry : permsList) {
                    if (!name.equals(accessControlEntry.getIdentity())) continue;
                    userPermission.append(accessControlEntry.getPermission()).append(" ");
                }
                int numPermission = 0;
                for (String perm : PermissionType.ALL) {
                    if (!userPermission.toString().contains(perm)) continue;
                    ++numPermission;
                }
                if (numPermission == PermissionType.ALL.length) {
                    permissionManager.getUIFormCheckBoxInput(UIPermissionManager.ACCESSIBLE_CHECKBOX_INPUT).setChecked(true);
                    permissionManager.getUIFormCheckBoxInput(UIPermissionManager.EDITABLE_CHECKBOX_INPUT).setChecked(true);
                } else {
                    permissionManager.getUIFormCheckBoxInput(UIPermissionManager.ACCESSIBLE_CHECKBOX_INPUT).setChecked(true);
                    permissionManager.getUIFormCheckBoxInput(UIPermissionManager.EDITABLE_CHECKBOX_INPUT).setChecked(false);
                }
                permissionManager.setActions(new String[]{"Save", "Clear"});
                permissionInputSet.setActionInfo(UIPermissionManager.PERMISSION_STRING_INPUT, new String[]{"SelectUser", "SelectMember", "AddAny"});
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIPermissionManager> {
        public void execute(Event<UIPermissionManager> event) throws Exception {
            String nodeOwner;
            UIPermissionManager permissionManager = (UIPermissionManager)((Object)event.getSource());
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)((UIPopupContainer)permissionManager.getAncestorOfType(UIPopupContainer.class)).getChild(UIContentDialogForm.class);
            NodeLocation webcontentNodeLocation = contentDialogForm.getWebcontentNodeLocation();
            Node node = NodeLocation.getNodeByLocation((NodeLocation)webcontentNodeLocation);
            ExtendedNode webcontent = (ExtendedNode)node;
            Session session = webcontent.getSession();
            String name = event.getRequestContext().getRequestParameter("objectId");
            if (name.equals(nodeOwner = webcontent.getProperty("exo:owner").getString())) {
                Utils.createPopupMessage((UIContainer)permissionManager, "UIPermissionManagerGrid.msg.no-permission-remove", null, 1);
                return;
            }
            if (permissionManager.hasChangePermissionRight(webcontent)) {
                if (webcontent.canAddMixin("exo:privilegeable")) {
                    webcontent.addMixin("exo:privilegeable");
                    webcontent.setPermission(nodeOwner, PermissionType.ALL);
                }
                try {
                    webcontent.removePermission(name);
                    session.save();
                    permissionManager.updateGrid();
                }
                catch (AccessControlException e) {
                    Object[] args = new Object[]{webcontent.getPath()};
                    Utils.createPopupMessage((UIContainer)permissionManager, "UIPermissionManagerGrid.msg.node-locked", args, 1);
                    return;
                }
                catch (AccessDeniedException ace) {
                    Utils.createPopupMessage((UIContainer)permissionManager, "UIPermissionManagerGrid.msg.access-denied", null, 1);
                    return;
                }
            }
        }
    }
}

