/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.wcm.webui.selector.content.UIContentBrowsePanel;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/wcm/webui/selector/UISelectPathPanel.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UISelectPathPanel
extends UIContainer {
    private UIPageIterator uiPageIterator_;
    public String[] acceptedMimeTypes = new String[0];
    protected Node parentNode;
    private String[] acceptedNodeTypes = new String[0];
    private String[] exceptedNodeTypes = new String[0];
    private String[] defaultExceptedNodeTypes = new String[0];
    private boolean allowPublish = false;
    protected PublicationService publicationService_ = null;
    private List<String> templates_ = null;
    static final String PATH = "path".intern();
    private boolean isDMSDocument;
    private boolean isWebContent;

    public boolean isWebContent() {
        return this.isWebContent;
    }

    public void setWebContent(boolean isWebContent) {
        this.isWebContent = isWebContent;
    }

    public boolean isDMSDocument() {
        return this.isDMSDocument;
    }

    public void setDMSDocument(boolean isDMSDocument) {
        this.isDMSDocument = isDMSDocument;
    }

    public UISelectPathPanel() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UISelectPathIterate");
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public boolean isAllowPublish() {
        return this.allowPublish;
    }

    public void setAllowPublish(boolean allowPublish, PublicationService publicationService, List<String> templates) {
        this.allowPublish = allowPublish;
        this.publicationService_ = publicationService;
        this.templates_ = templates;
    }

    protected void addNodePublish(List<Node> listNode, Node node, PublicationService publicationService) throws Exception {
        if (this.isAllowPublish()) {
            NodeType nt = node.getPrimaryNodeType();
            if (this.templates_.contains(nt.getName())) {
                Node nodecheck = publicationService.getNodePublish(node, null);
                if (nodecheck != null) {
                    listNode.add(nodecheck);
                }
            } else {
                listNode.add(node);
            }
        } else {
            listNode.add(node);
        }
    }

    public void setParentNode(Node node) {
        this.parentNode = node;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public String[] getAcceptedNodeTypes() {
        return this.acceptedNodeTypes;
    }

    public void setAcceptedNodeTypes(String[] acceptedNodeTypes) {
        this.acceptedNodeTypes = acceptedNodeTypes;
    }

    public String[] getExceptedNodeTypes() {
        return this.exceptedNodeTypes;
    }

    public void setExceptedNodeTypes(String[] exceptedNodeTypes) {
        this.exceptedNodeTypes = exceptedNodeTypes;
    }

    public String[] getDefaultExceptedNodeTypes() {
        return this.defaultExceptedNodeTypes;
    }

    public void setDefaultExceptedNodeTypes(String[] defaultExceptedNodeTypes) {
        this.defaultExceptedNodeTypes = defaultExceptedNodeTypes;
    }

    public String[] getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    public void setAcceptedMimeTypes(String[] acceptedMimeTypes) {
        this.acceptedMimeTypes = acceptedMimeTypes;
    }

    public List getSelectableNodes() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getListSelectableNodes(), 4);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public List<Node> getListSelectableNodes() throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.parentNode == null) {
            return list;
        }
        Node realNode = Utils.getNodeSymLink((Node)this.parentNode);
        NodeIterator iterator = realNode.getNodes();
        while (iterator.hasNext()) {
            Node symChild;
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:hiddenable") || !this.filterNode(symChild = Utils.getNodeSymLink((Node)child)) || !this.isValidState(symChild)) continue;
            list.add(child);
        }
        ArrayList<Node> listNodeCheck = new ArrayList<Node>();
        for (Node node : list) {
            this.addNodePublish(listNodeCheck, node, this.publicationService_);
        }
        return listNodeCheck;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)Util.getUIPortalApplication().getChild(UIMaskWorkspace.class);
        if (maskWorkspace != null) {
            maskWorkspace.setUpdated(true);
        }
        super.processRender(context);
    }

    private boolean isValidState(Node node) throws Exception {
        WCMPublicationService publicationService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        String state = publicationService.getContentState(node);
        if (state == null) {
            return true;
        }
        WCMComposer composer = (WCMComposer)this.getApplicationComponent(WCMComposer.class);
        List states = composer.getAllowedStates("Edit");
        return states.contains(state);
    }

    protected boolean isExceptedNodeType(Node node) throws RepositoryException {
        if (this.defaultExceptedNodeTypes.length > 0) {
            for (String nodeType : this.defaultExceptedNodeTypes) {
                if (node == null || !node.isNodeType(nodeType)) continue;
                return true;
            }
        }
        if (this.exceptedNodeTypes == null || this.exceptedNodeTypes.length == 0) {
            return false;
        }
        for (String nodeType : this.exceptedNodeTypes) {
            if (node == null || !node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    private boolean filterNode(Node node) throws RepositoryException {
        if (this.acceptedNodeTypes == null || this.acceptedNodeTypes.length == 0) {
            return false;
        }
        NodeType[] superTypes = null;
        if (this.isWebContent()) {
            superTypes = node.getPrimaryNodeType().getSupertypes();
            for (String nodeType : this.acceptedNodeTypes) {
                if (node.isNodeType(nodeType)) {
                    return true;
                }
                for (NodeType superType : superTypes) {
                    if (!superType.isNodeType(nodeType)) continue;
                    return true;
                }
            }
        } else if (this.isDMSDocument()) {
            String[] webContentNodeTypes;
            superTypes = node.getPrimaryNodeType().getSupertypes();
            for (String webContentNodeType : webContentNodeTypes = UIContentBrowsePanel.WEBCONTENT_NODERTYPE) {
                if (node.isNodeType(webContentNodeType)) {
                    return false;
                }
                for (NodeType superType : superTypes) {
                    if (!superType.isNodeType(webContentNodeType)) continue;
                    return false;
                }
            }
            for (String nodeType : this.acceptedNodeTypes) {
                if (node.isNodeType("nt:file")) {
                    return this.filterDMSDocumentMimeType(node);
                }
                if (!node.isNodeType(nodeType)) continue;
                return true;
            }
        } else {
            return this.filterMediaMimetype(node);
        }
        return false;
    }

    private boolean filterDMSDocumentMimeType(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException {
        String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        String[] mediaMimeTypes = UIContentBrowsePanel.MEDIA_MIMETYPE;
        if (mediaMimeTypes == null || mediaMimeTypes.length == 0) {
            return false;
        }
        for (String type : mediaMimeTypes) {
            if (!mimeType.contains(type)) continue;
            return false;
        }
        return true;
    }

    private boolean filterMediaMimetype(Node node) throws RepositoryException {
        if (!node.isNodeType("nt:file")) {
            return false;
        }
        if (this.acceptedMimeTypes == null || this.acceptedMimeTypes.length == 0) {
            return false;
        }
        String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        for (String type : this.acceptedMimeTypes) {
            if (!mimeType.contains(type)) continue;
            return true;
        }
        return false;
    }

    public String getPathTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UISelectPathPanel> {
        public void execute(Event<UISelectPathPanel> event) throws Exception {
            UISelectPathPanel uiSelectPathPanel = (UISelectPathPanel)((Object)event.getSource());
            UIContainer uiTreeSelector = (UIContainer)uiSelectPathPanel.getParent();
            String value = event.getRequestContext().getRequestParameter("objectId");
            String[] values = value.split("/");
            value = value.replaceAll(values[values.length - 1], Text.escapeIllegalJcrChars((String)values[values.length - 1]));
            if (uiTreeSelector instanceof UIOneNodePathSelector && !((UIOneNodePathSelector)uiTreeSelector).isDisable()) {
                value = ((UIOneNodePathSelector)uiTreeSelector).getWorkspaceName() + ":" + value;
            }
            if (value == null) {
                UIApplication uiApplication = (UIApplication)uiSelectPathPanel.getAncestorOfType(UIApplication.class);
                uiApplication.addMessage(new ApplicationMessage("UIDMSSelectorForm.msg.require-choose", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
                return;
            }
            RepositoryService repositoryService = (RepositoryService)uiSelectPathPanel.getApplicationComponent(RepositoryService.class);
            String repoName = repositoryService.getCurrentRepository().getConfiguration().getName();
            WCMConfigurationService configurationService = (WCMConfigurationService)uiSelectPathPanel.getApplicationComponent(WCMConfigurationService.class);
            NodeLocation nodeLocation = configurationService.getLivePortalsLocation(repoName);
            ManageableRepository manageableRepository = repositoryService.getRepository(nodeLocation.getRepository());
            Session session = ((ThreadLocalSessionProviderService)uiSelectPathPanel.getApplicationComponent(ThreadLocalSessionProviderService.class)).getSessionProvider(null).getSession(nodeLocation.getWorkspace(), manageableRepository);
            Node webContent = (Node)session.getItem(value);
            UIContentBrowsePanel uiContentBrowsePanel = (UIContentBrowsePanel)uiSelectPathPanel.getAncestorOfType(UIContentBrowsePanel.class);
            uiContentBrowsePanel.doSelect(webContent, event.getRequestContext());
        }
    }
}

