/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.wcm.webui.selector.content.UIContentSearchForm;
import org.exoplatform.wcm.webui.selector.content.UIContentSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIContentNodeTypeSelector
extends UIForm {
    public void init() throws Exception {
        this.getChildren().clear();
        UIPopupWindow uiPopup = (UIPopupWindow)this.getAncestorOfType(UIPopupWindow.class);
        UIContentSelector uiWCTabSelector = (UIContentSelector)uiPopup.getAncestorOfType(UIContentSelector.class);
        List<Object> nodeTypes = new ArrayList();
        nodeTypes = uiWCTabSelector != null ? this.getWebContentNodeTypes() : this.getDocumentNodeTypes();
        for (String string : nodeTypes) {
            UIFormCheckBoxInput uiCheckBox = new UIFormCheckBoxInput(string, string, (Object)"");
            if (this.propertiesSelected(string)) {
                uiCheckBox.setChecked(true);
            } else {
                uiCheckBox.setChecked(false);
            }
            this.addUIFormInput((UIFormInput)uiCheckBox);
        }
    }

    private boolean propertiesSelected(String name) {
        UIPopupWindow uiPopupWindow = (UIPopupWindow)this.getParent();
        UIContentSelector contentSelector = (UIContentSelector)uiPopupWindow.getAncestorOfType(UIContentSelector.class);
        UIContentSearchForm contentSearchForm = (UIContentSearchForm)contentSelector.getChild(UIContentSearchForm.class);
        String typeValues = (String)contentSearchForm.getUIStringInput("docType").getValue();
        if (typeValues == null) {
            return false;
        }
        if (typeValues.indexOf(",") > -1) {
            String[] values;
            for (String value : values = typeValues.split(",")) {
                if (!value.equals(name)) continue;
                return true;
            }
        } else if (typeValues.equals(name)) {
            return true;
        }
        return false;
    }

    private void setNodeTypes(List<String> selectedNodeTypes, UIContentSearchForm uiWCSearchForm) {
        String strNodeTypes = null;
        for (int i = 0; i < selectedNodeTypes.size(); ++i) {
            strNodeTypes = strNodeTypes == null ? selectedNodeTypes.get(i) : strNodeTypes + "," + selectedNodeTypes.get(i);
        }
        uiWCSearchForm.getUIStringInput("docType").setValue(strNodeTypes);
    }

    private List<String> getWebContentNodeTypes() throws Exception {
        ArrayList<String> webContentNodeTypes = new ArrayList<String>();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ExtendedNodeTypeManager nodeTypeManager = repoService.getCurrentRepository().getNodeTypeManager();
        NodeTypeIterator nodeTypeIterator = nodeTypeManager.getAllNodeTypes();
        while (nodeTypeIterator.hasNext()) {
            NodeType nodeType = nodeTypeIterator.nextNodeType();
            if (!nodeType.isNodeType("exo:webContent")) continue;
            webContentNodeTypes.add(nodeType.getName());
        }
        return webContentNodeTypes;
    }

    private List<String> getDocumentNodeTypes() throws Exception {
        List documentNodeTypes = new ArrayList();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repositoryName = repoService.getCurrentRepository().getConfiguration().getName();
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        documentNodeTypes = tempService.getDocumentTemplates(repositoryName);
        ExtendedNodeTypeManager nodeTypeManager = repoService.getCurrentRepository().getNodeTypeManager();
        ArrayList<String> resultNodeTypes = new ArrayList<String>();
        for (String documentNodeType : documentNodeTypes) {
            NodeType nodeType = nodeTypeManager.getNodeType(documentNodeType);
            if (nodeType.isNodeType("exo:webContent")) continue;
            resultNodeTypes.add(nodeType.getName());
        }
        return resultNodeTypes;
    }

    private void makeSelectedNode(String nodeTypesValue, List<String> selectedNodeTypes, List<UIFormCheckBoxInput> listCheckbox) throws Exception {
        if (nodeTypesValue != null && nodeTypesValue.length() > 0) {
            String[] array = nodeTypesValue.split(",");
            for (int i = 0; i < array.length; ++i) {
                selectedNodeTypes.add(array[i].trim());
            }
        }
        for (int i = 0; i < listCheckbox.size(); ++i) {
            if (listCheckbox.get(i).isChecked()) {
                if (selectedNodeTypes.contains(listCheckbox.get(i).getName())) continue;
                selectedNodeTypes.add(listCheckbox.get(i).getName());
                continue;
            }
            if (selectedNodeTypes.contains(listCheckbox.get(i))) {
                selectedNodeTypes.remove(listCheckbox.get(i).getName());
                continue;
            }
            selectedNodeTypes.remove(listCheckbox.get(i).getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIContentNodeTypeSelector> {
        public void execute(Event<UIContentNodeTypeSelector> event) throws Exception {
            UIContentNodeTypeSelector contentNodetypeSelector = (UIContentNodeTypeSelector)((Object)event.getSource());
            UIPopupWindow uiPopupWindow = (UIPopupWindow)contentNodetypeSelector.getAncestorOfType(UIPopupWindow.class);
            UIContentSelector contentSelector = (UIContentSelector)uiPopupWindow.getAncestorOfType(UIContentSelector.class);
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)contentSelector.getChild(UIContentSearchForm.class);
            contentSelector.removeChild(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentSelector);
            contentSelector.setSelectedTab(contentSearchForm.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIContentNodeTypeSelector> {
        public void execute(Event<UIContentNodeTypeSelector> event) throws Exception {
            UIContentNodeTypeSelector contentNodetypeSelector = (UIContentNodeTypeSelector)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)contentNodetypeSelector.getAncestorOfType(UIPopupWindow.class);
            UIContentSelector contentSelector = (UIContentSelector)uiPopup.getAncestorOfType(UIContentSelector.class);
            ArrayList selectedNodeTypes = new ArrayList();
            ArrayList listCheckbox = new ArrayList();
            contentNodetypeSelector.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)contentSelector.getChild(UIContentSearchForm.class);
            String nodeTypesValue = (String)contentSearchForm.getUIStringInput("docType").getValue();
            contentNodetypeSelector.makeSelectedNode(nodeTypesValue, selectedNodeTypes, listCheckbox);
            contentNodetypeSelector.setNodeTypes(selectedNodeTypes, contentSearchForm);
            contentSelector.removeChild(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentSelector);
            contentSelector.setSelectedTab(contentSearchForm.getId());
        }
    }
}

