/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.content.UIContentBrowsePanel;
import org.exoplatform.wcm.webui.selector.content.UIContentSearchResult;
import org.exoplatform.wcm.webui.selector.content.UIContentSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/selector/content/UIContentSearchForm.gtmpl", events={@EventConfig(listeners={SearchWebContentActionListener.class}), @EventConfig(listeners={AddMetadataTypeActionListener.class}), @EventConfig(listeners={AddNodeTypeActionListener.class})})
public class UIContentSearchForm
extends UIForm {
    public static final String LOCATION = "location".intern();
    public static final String SEARCH_BY_NAME = "name".intern();
    public static final String SEARCH_BY_CONTENT = "content".intern();
    public static final String RADIO_NAME = "WcmRadio".intern();
    public static final String TIME_OPTION = "timeOpt";
    public static final String PROPERTY = "property";
    public static final String CONTAIN = "contain";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String DOC_TYPE = "docType";
    public static final String CATEGORY = "category";
    public static final String CREATED_DATE = "CREATED";
    public static final String MODIFIED_DATE = "MODIFIED";
    public static final String EXACTLY_PROPERTY = "exactlyPro";
    public static final String CONTAIN_PROPERTY = "containPro";
    public static final String NOT_CONTAIN_PROPERTY = "notContainPro";
    public static final String DATE_PROPERTY = "datePro";
    public static final String NODETYPE_PROPERTY = "nodetypePro";
    public static final String CHECKED_RADIO_ID = "checkedRadioId".intern();
    private String checkedRadioId;

    public void init() throws Exception {
        ArrayList<SelectItemOption> portalNameOptions = new ArrayList<SelectItemOption>();
        List<String> portalNames = this.getPortalNames();
        for (String portalName : portalNames) {
            portalNameOptions.add(new SelectItemOption(portalName, (Object)portalName));
        }
        UIFormSelectBox portalNameSelectBox = new UIFormSelectBox(LOCATION, LOCATION, portalNameOptions);
        portalNameSelectBox.setDefaultValue((Object)portalNames.get(0));
        this.addChild((UIComponent)portalNameSelectBox);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_BY_NAME, SEARCH_BY_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_BY_CONTENT, SEARCH_BY_CONTENT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PROPERTY, PROPERTY, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONTAIN, CONTAIN, null));
        ArrayList<SelectItemOption> dateOptions = new ArrayList<SelectItemOption>();
        dateOptions.add(new SelectItemOption(CREATED_DATE, (Object)CREATED_DATE));
        dateOptions.add(new SelectItemOption(MODIFIED_DATE, (Object)MODIFIED_DATE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TIME_OPTION, TIME_OPTION, dateOptions));
        UIFormDateTimeInput startTime = new UIFormDateTimeInput(START_TIME, START_TIME, null, true);
        this.addUIFormInput((UIFormInput)startTime);
        UIFormDateTimeInput endTime = new UIFormDateTimeInput(END_TIME, END_TIME, null, true);
        this.addUIFormInput((UIFormInput)endTime);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DOC_TYPE, DOC_TYPE, null));
        this.setActions(new String[]{"SearchWebContent"});
    }

    private List<String> getPortalNames() throws Exception {
        ArrayList<String> portalNames = new ArrayList<String>();
        String currentPortalName = Util.getUIPortal().getName();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repository = repoService.getCurrentRepository().getConfiguration().getName();
        WCMConfigurationService configService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        String sharedPortalName = configService.getSharedPortalName(repository);
        portalNames.add(currentPortalName);
        portalNames.add(sharedPortalName);
        return portalNames;
    }

    private PaginatedQueryResult searchWebContentByName(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(false);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private PaginatedQueryResult searchWebContentByFulltext(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(".");
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private PaginatedQueryResult searchWebContentByProperty(String property, String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(property);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearchService.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private PaginatedQueryResult searchWebContentByDate(QueryCriteria.DATE_RANGE_SELECTED dateRangeSelected, Calendar fromDate, Calendar endDate, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setDateRangeSelected(dateRangeSelected);
        QueryCriteria.DatetimeRange dateTimeRange = new QueryCriteria.DatetimeRange(fromDate, endDate);
        if (QueryCriteria.DATE_RANGE_SELECTED.CREATED.equals((Object)dateRangeSelected)) {
            qCriteria.setCreatedDateRange(dateTimeRange);
        } else if (QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED.equals((Object)dateRangeSelected)) {
            qCriteria.setLastModifiedDateRange(dateTimeRange);
        }
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private PaginatedQueryResult searchWebContentByDocumentType(String documentType, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        qCriteria.setContentTypes(documentType.split(","));
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private QueryCriteria getInitialQueryCriteria(String siteName) {
        QueryCriteria qCriteria = new QueryCriteria();
        String contentType = ((UIContentBrowsePanel)((UIContentSelector)this.getAncestorOfType(UIContentSelector.class)).getChild(UIContentBrowsePanel.class)).contentType;
        if ("WebContent".equals(contentType)) {
            qCriteria.setSearchDocument(false);
            qCriteria.setSearchWebContent(true);
        } else if ("DMSDocument".equals(contentType)) {
            qCriteria.setSearchDocument(true);
            qCriteria.setSearchWebContent(false);
        }
        qCriteria.setSearchWebpage(false);
        qCriteria.setSiteName(siteName);
        qCriteria.setLiveMode(false);
        return qCriteria;
    }

    private boolean haveEmptyField(UIApplication uiApp, Event<UIContentSearchForm> event, String ... fields) throws Exception {
        for (String field : fields) {
            if (field != null && !"".equals(field) && field.toString().trim().length() > 0) continue;
            uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.empty-field", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return true;
        }
        return false;
    }

    private PaginatedQueryResult searchDocumentByName(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(false);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private PaginatedQueryResult searchDocumentByFulltext(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(".");
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private PaginatedQueryResult searchDocumentByProperty(String property, String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(property);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearchService.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private PaginatedQueryResult searchDocumentByDate(QueryCriteria.DATE_RANGE_SELECTED dateRangeSelected, Calendar fromDate, Calendar endDate, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setDateRangeSelected(dateRangeSelected);
        QueryCriteria.DatetimeRange dateTimeRange = new QueryCriteria.DatetimeRange(fromDate, endDate);
        if (QueryCriteria.DATE_RANGE_SELECTED.CREATED.equals((Object)dateRangeSelected)) {
            qCriteria.setCreatedDateRange(dateTimeRange);
        } else if (QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED.equals((Object)dateRangeSelected)) {
            qCriteria.setLastModifiedDateRange(dateTimeRange);
        }
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    private PaginatedQueryResult searchDocumentByType(String documentType, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        qCriteria.setContentTypes(documentType.split(","));
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(Utils.getSessionProvider(), qCriteria, pageSize, true);
    }

    public String getCheckedRadioId() {
        return this.checkedRadioId;
    }

    public void setCheckedRadioId(String checkedRadioId) {
        this.checkedRadioId = checkedRadioId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchWebContentActionListener
    extends EventListener<UIContentSearchForm> {
        public void execute(Event<UIContentSearchForm> event) throws Exception {
            String documentType;
            UIFormDateTimeInput startDateInput;
            String property;
            String keyword;
            UIContentSearchForm uiWCSearch = (UIContentSearchForm)((Object)event.getSource());
            String typeSearch = ((UIContentBrowsePanel)((UIContentSelector)uiWCSearch.getAncestorOfType(UIContentSelector.class)).getChild(UIContentBrowsePanel.class)).contentType;
            int pageSize = 5;
            String radioValue = event.getRequestContext().getRequestParameter(RADIO_NAME);
            String siteName = (String)uiWCSearch.getUIStringInput(LOCATION).getValue();
            UIContentSelector uiWCTabSelector = (UIContentSelector)uiWCSearch.getParent();
            UIApplication uiApp = (UIApplication)uiWCSearch.getAncestorOfType(UIApplication.class);
            QueryCriteria qCriteria = uiWCSearch.getInitialQueryCriteria(siteName);
            PaginatedQueryResult pagResult = null;
            if (typeSearch.equals("WebContent") || typeSearch.equals("Media")) {
                if (SEARCH_BY_NAME.equals(radioValue)) {
                    keyword = (String)uiWCSearch.getUIStringInput(radioValue).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{keyword})) {
                        return;
                    }
                    pagResult = uiWCSearch.searchWebContentByName(keyword.trim(), qCriteria, pageSize);
                } else if (SEARCH_BY_CONTENT.equals(radioValue)) {
                    keyword = (String)uiWCSearch.getUIStringInput(radioValue).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{keyword})) {
                        return;
                    }
                    pagResult = uiWCSearch.searchWebContentByFulltext(keyword, qCriteria, pageSize);
                } else if (UIContentSearchForm.PROPERTY.equals(radioValue)) {
                    String keyword2;
                    property = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.PROPERTY).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{property, keyword2 = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.CONTAIN).getValue()})) {
                        return;
                    }
                    pagResult = uiWCSearch.searchWebContentByProperty(property, keyword2, qCriteria, pageSize);
                } else if (UIContentSearchForm.TIME_OPTION.equals(radioValue)) {
                    startDateInput = uiWCSearch.getUIFormDateTimeInput(UIContentSearchForm.START_TIME);
                    UIFormDateTimeInput endDateInput = uiWCSearch.getUIFormDateTimeInput(UIContentSearchForm.END_TIME);
                    try {
                        new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse((String)startDateInput.getValue());
                    }
                    catch (ParseException e) {
                        uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-format", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    Calendar startDate = startDateInput.getCalendar();
                    Calendar endDate = endDateInput.getCalendar();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{(String)startDateInput.getValue()})) {
                        return;
                    }
                    if (endDate == null) {
                        endDate = startDate.getTimeInMillis() > Calendar.getInstance().getTimeInMillis() ? startDate : Calendar.getInstance();
                    }
                    if (startDate.getTimeInMillis() > endDate.getTimeInMillis()) {
                        uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-date", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    String dateRangeSelected = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.TIME_OPTION).getValue();
                    pagResult = UIContentSearchForm.CREATED_DATE.equals(dateRangeSelected) ? uiWCSearch.searchWebContentByDate(QueryCriteria.DATE_RANGE_SELECTED.CREATED, startDate, endDate, qCriteria, pageSize) : uiWCSearch.searchWebContentByDate(QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED, startDate, endDate, qCriteria, pageSize);
                } else if (UIContentSearchForm.DOC_TYPE.equals(radioValue)) {
                    documentType = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.DOC_TYPE).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{documentType})) {
                        return;
                    }
                    try {
                        pagResult = uiWCSearch.searchWebContentByDocumentType(documentType, qCriteria, pageSize);
                    }
                    catch (Exception ex) {
                        uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-nodeType", new Object[]{documentType}, 0));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
            } else if (typeSearch.equals("DMSDocument")) {
                if (SEARCH_BY_NAME.equals(radioValue)) {
                    keyword = (String)uiWCSearch.getUIStringInput(radioValue).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{keyword})) {
                        return;
                    }
                    pagResult = uiWCSearch.searchDocumentByName(keyword.trim(), qCriteria, pageSize);
                } else if (SEARCH_BY_CONTENT.equals(radioValue)) {
                    keyword = (String)uiWCSearch.getUIStringInput(radioValue).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{keyword})) {
                        return;
                    }
                    pagResult = uiWCSearch.searchDocumentByFulltext(keyword, qCriteria, pageSize);
                } else if (UIContentSearchForm.PROPERTY.equals(radioValue)) {
                    String keyword3;
                    property = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.PROPERTY).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{property, keyword3 = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.CONTAIN).getValue()})) {
                        return;
                    }
                    pagResult = uiWCSearch.searchDocumentByProperty(property, keyword3, qCriteria, pageSize);
                } else if (UIContentSearchForm.TIME_OPTION.equals(radioValue)) {
                    startDateInput = uiWCSearch.getUIFormDateTimeInput(UIContentSearchForm.START_TIME);
                    UIFormDateTimeInput endDateInput = uiWCSearch.getUIFormDateTimeInput(UIContentSearchForm.END_TIME);
                    try {
                        new SimpleDateFormat(startDateInput.getDatePattern_()).parse((String)startDateInput.getValue());
                        new SimpleDateFormat(endDateInput.getDatePattern_()).parse((String)endDateInput.getValue());
                    }
                    catch (Exception e) {
                        uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-format", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    Calendar startDate = startDateInput.getCalendar();
                    Calendar endDate = endDateInput.getCalendar();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{(String)startDateInput.getValue()})) {
                        return;
                    }
                    if (endDate == null) {
                        endDate = startDate.getTimeInMillis() > Calendar.getInstance().getTimeInMillis() ? startDate : Calendar.getInstance();
                    }
                    if (startDate.getTimeInMillis() > endDate.getTimeInMillis()) {
                        uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-date", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    String dateRangeSelected = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.TIME_OPTION).getValue();
                    pagResult = UIContentSearchForm.CREATED_DATE.equals(dateRangeSelected) ? uiWCSearch.searchDocumentByDate(QueryCriteria.DATE_RANGE_SELECTED.CREATED, startDate, endDate, qCriteria, pageSize) : uiWCSearch.searchDocumentByDate(QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED, startDate, endDate, qCriteria, pageSize);
                } else if (UIContentSearchForm.DOC_TYPE.equals(radioValue)) {
                    documentType = (String)uiWCSearch.getUIStringInput(UIContentSearchForm.DOC_TYPE).getValue();
                    if (uiWCSearch.haveEmptyField(uiApp, (Event<UIContentSearchForm>)event, new String[]{documentType})) {
                        return;
                    }
                    try {
                        pagResult = uiWCSearch.searchDocumentByType(documentType, qCriteria, pageSize);
                    }
                    catch (Exception exception) {
                        uiApp.addMessage(new ApplicationMessage("UIContentSearchForm.msg.invalid-nodeType", new Object[]{documentType}, 0));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
            }
            UIContentSearchResult uiWCSearchResult = (UIContentSearchResult)uiWCTabSelector.getChild(UIContentSearchResult.class);
            uiWCSearchResult.updateGrid(pagResult);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWCTabSelector);
            uiWCTabSelector.setSelectedTab(uiWCSearchResult.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNodeTypeActionListener
    extends EventListener<UIContentSearchForm> {
        public void execute(Event<UIContentSearchForm> event) throws Exception {
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)((Object)event.getSource());
            UIContentSelector contentSelector = (UIContentSelector)contentSearchForm.getParent();
            contentSearchForm.setCheckedRadioId(event.getRequestContext().getRequestParameter(CHECKED_RADIO_ID));
            contentSelector.initNodeTypePopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentSelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddMetadataTypeActionListener
    extends EventListener<UIContentSearchForm> {
        public void execute(Event<UIContentSearchForm> event) throws Exception {
            UIContentSearchForm contentSearchForm = (UIContentSearchForm)((Object)event.getSource());
            UIContentSelector contentSelector = (UIContentSelector)contentSearchForm.getParent();
            contentSearchForm.setCheckedRadioId(event.getRequestContext().getRequestParameter(CHECKED_RADIO_ID));
            contentSelector.initMetadataPopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentSelector);
        }
    }
}

