/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.NodeLocation;

public class UIContentTreeNode {
    private String treePath;
    private int deep;
    private String name;
    private NodeLocation nodeLocation;
    private String workSpaceName;
    private static Log log = ExoLogger.getLogger(UIContentTreeNode.class);

    public UIContentTreeNode(String path, String workSpaceName, Node node, int deep) {
        this.name = null;
        this.nodeLocation = NodeLocation.make((Node)node);
        this.deep = deep;
        this.workSpaceName = workSpaceName;
        try {
            this.treePath = path + "/" + this.getName();
        }
        catch (RepositoryException e) {
            log.error((Object)"Error when perform generate tree node: ", e.fillInStackTrace());
        }
    }

    public UIContentTreeNode(String name) {
        this.name = name;
        this.treePath = "/" + name;
        this.nodeLocation = null;
        this.deep = 0;
    }

    public UIContentTreeNode(String path, String name, String workSpaceName, Node node, int deep) {
        this.name = name;
        this.nodeLocation = NodeLocation.make((Node)node);
        this.deep = deep;
        this.workSpaceName = workSpaceName;
        this.treePath = path + "/" + name;
    }

    public String getName() throws RepositoryException {
        StringBuilder buffer = new StringBuilder(128);
        if (this.name == null || this.name.trim().length() < 1) {
            Node node = this.getNode();
            buffer.append(node.getName());
            int index = node.getIndex();
            if (index > 1) {
                buffer.append('[');
                buffer.append(index);
                buffer.append(']');
            }
        } else {
            buffer.append(this.name);
        }
        return buffer.toString();
    }

    public String getNodePath() throws RepositoryException {
        Node node = this.getNode();
        if (node != null) {
            return node.getPath();
        }
        return null;
    }

    public Node getNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.nodeLocation);
    }

    public void setNode(Node node) {
        this.nodeLocation = NodeLocation.make((Node)node);
    }

    public int getDeep() {
        return this.deep;
    }

    public void setDeep(int deep) {
        this.deep = deep;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWorkSpaceName() {
        return this.workSpaceName;
    }

    public void setWorkSpaceName(String workSpaceName) {
        this.workSpaceName = workSpaceName;
    }

    public String getTreePath() {
        return this.treePath;
    }

    public void setTreePath(String treePath) {
        this.treePath = treePath;
    }
}

