/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content.one;

import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.core.NodeIdentifier;
import org.exoplatform.services.wcm.publication.NotInWCMPublicationException;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.UISelectPathPanel;
import org.exoplatform.wcm.webui.selector.content.UIContentBrowsePanel;
import org.exoplatform.wcm.webui.selector.content.UIContentTreeBuilder;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/wcm/webui/selector/content/one/UIContentBrowsePanel.gtmpl", events={@EventConfig(listeners={UIContentBrowsePanel.ChangeContentTypeActionListener.class})}), @ComponentConfig(type=UISelectPathPanel.class, id="UIContentBrowsePathSelector", template="classpath:groovy/wcm/webui/selector/content/UIContentBrowsePathSelector.gtmpl", events={@EventConfig(listeners={UISelectPathPanel.SelectActionListener.class})})})
public class UIContentBrowsePanelOne
extends UIContentBrowsePanel {
    public UIContentBrowsePanelOne() throws Exception {
        this.addChild(UIContentTreeBuilder.class, null, UIContentTreeBuilder.class.getName() + ((Object)((Object)this)).hashCode());
        this.addChild(UISelectPathPanel.class, "UIContentBrowsePathSelector", "UIContentBrowsePathSelector");
    }

    public void doSelect(Node node, WebuiRequestContext requestContext) throws Exception {
        Node realNode = node;
        if (node.isNodeType("exo:symlink")) {
            String uuid = node.getProperty("exo:uuid").getString();
            realNode = node.getSession().getNodeByUUID(uuid);
        }
        if (!realNode.isCheckedOut()) {
            Utils.createPopupMessage((UIContainer)this, "UIContentBrowsePanelOne.msg.node-checkout", null, 1);
            return;
        }
        NodeIdentifier nodeIdentifier = NodeIdentifier.make((Node)realNode);
        PortletRequestContext pContext = (PortletRequestContext)requestContext;
        PortletPreferences prefs = pContext.getRequest().getPreferences();
        prefs.setValue("repository", nodeIdentifier.getRepository());
        prefs.setValue("workspace", nodeIdentifier.getWorkspace());
        prefs.setValue("nodeIdentifier", nodeIdentifier.getUUID());
        prefs.store();
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        String portalOwner = Util.getPortalRequestContext().getPortalOwner();
        WCMPublicationService wcmPublicationService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        try {
            wcmPublicationService.isEnrolledInWCMLifecycle(realNode);
        }
        catch (NotInWCMPublicationException e) {
            wcmPublicationService.unsubcribeLifecycle(realNode);
            wcmPublicationService.enrollNodeInLifecycle(realNode, portalOwner, remoteUser);
        }
        wcmPublicationService.updateLifecyleOnChangeContent(realNode, portalOwner, remoteUser, null);
        if (!Utils.isEditPortletInCreatePageWizard()) {
            String pageId = Util.getUIPortal().getSelectedNode().getPageReference();
            UserPortalConfigService upcService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
            wcmPublicationService.updateLifecyleOnChangePage(upcService.getPage(pageId), remoteUser);
        }
        Utils.closePopupWindow((UIContainer)this, "UIContentDialogFormPopupWindow");
    }
}

