/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content.multi;

import java.util.List;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectmany.UISelectedCategoriesGrid;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.UISourceGridUpdatable;
import org.exoplatform.wcm.webui.selector.content.UIContentBrowsePanel;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/wcm/webui/selector/content/multi/UICLVContentSelectedGrid.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UISelectedContentGrid.msg.confirm-delete"), @EventConfig(listeners={SaveCategoriesActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UICLVContentSelectedGrid
extends UISelectedCategoriesGrid {
    public static final String CORRECT_CONTENT_SELECTOR_POPUP_WINDOW = "CorrectContentSelectorPopupWindow";

    public void init(List<String> contents) throws Exception {
        for (String content : contents) {
            if (this.getSelectedCategories().contains(content)) continue;
            this.addCategory(content);
            this.updateGrid(this.getUIPageIterator().getCurrentPage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UICLVContentSelectedGrid> {
        public void execute(Event<UICLVContentSelectedGrid> event) throws Exception {
            UICLVContentSelectedGrid uiSelectedContent = (UICLVContentSelectedGrid)((Object)event.getSource());
            UIContentBrowsePanel uiContentBrowsePanel = (UIContentBrowsePanel)uiSelectedContent.getAncestorOfType(UIContentBrowsePanel.class);
            Utils.closePopupWindow((UIContainer)uiContentBrowsePanel, UICLVContentSelectedGrid.CORRECT_CONTENT_SELECTOR_POPUP_WINDOW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveCategoriesActionListener
    extends EventListener<UICLVContentSelectedGrid> {
        public void execute(Event<UICLVContentSelectedGrid> event) throws Exception {
            UICLVContentSelectedGrid uiSelectedContentGrid = (UICLVContentSelectedGrid)((Object)event.getSource());
            UIContentBrowsePanel uiContentBrowsePanel = (UIContentBrowsePanel)uiSelectedContentGrid.getAncestorOfType(UIContentBrowsePanel.class);
            String returnField = uiContentBrowsePanel.getReturnFieldName();
            List selectedCategories = uiSelectedContentGrid.getSelectedCategories();
            if (selectedCategories.size() == 0) {
                Utils.createPopupMessage((UIContainer)uiContentBrowsePanel, "UISelectedContentGrid.msg.non-content", null, 2);
                return;
            }
            try {
                StringBuilder contents = new StringBuilder();
                for (String item : selectedCategories) {
                    contents.append(item).append(";");
                }
                UISelectable contentBrowsePanel = (UISelectable)uiContentBrowsePanel.getSourceComponent();
                contentBrowsePanel.doSelect(returnField, (Object)contents.toString());
                ((UISourceGridUpdatable)contentBrowsePanel).doSave(selectedCategories);
            }
            catch (Exception e) {
                Utils.createPopupMessage((UIContainer)uiContentBrowsePanel, "UISelectedCategoriesGrid.msg.cannot-save", null, 1);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UICLVContentSelectedGrid> {
        public void execute(Event<UICLVContentSelectedGrid> event) throws Exception {
            UICLVContentSelectedGrid uiSelectedContentGrid = (UICLVContentSelectedGrid)((Object)event.getSource());
            UIContentBrowsePanel uiContentBrowsePanel = (UIContentBrowsePanel)uiSelectedContentGrid.getAncestorOfType(UIContentBrowsePanel.class);
            UISelectable contentBrowsePanel = (UISelectable)uiContentBrowsePanel.getSourceComponent();
            String value = event.getRequestContext().getRequestParameter("objectId");
            uiSelectedContentGrid.removeCategory(value);
            uiSelectedContentGrid.updateGrid(uiSelectedContentGrid.getUIPageIterator().getCurrentPage());
            ((UISourceGridUpdatable)contentBrowsePanel).doSave(uiSelectedContentGrid.getSelectedCategories());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSelectedContentGrid.getParent());
        }
    }
}

