/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wcm.webui.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/wcmTreeContent/")
public class UpdateTreeConnector
implements ResourceContainer {
    public static final String FILE_TYPE_WEBCONTENT = "Web Contents";
    public static final String FILE_TYPE_DMSDOC = "DMS Documents";
    public static final String FILE_TYPE_MEDIAS = "Medias";

    @GET
    @Path(value="/getChildNodes/")
    public Response getChildNodes(@QueryParam(value="nodePath") String nodePath, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="repositoryName") String repositoryName) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        try {
            SessionProvider sessionProvider = Utils.getSystemSessionProvider();
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
            Session session = sessionProvider.getSession(workspaceName, manageableRepository);
            Node node = (Node)session.getItem(nodePath);
            NodeIterator nodeIterator = node.getNodes();
            int index = 0;
            Element parentNode = document.createElement("childNodes");
            document.appendChild(parentNode);
            while (nodeIterator.hasNext()) {
                node = nodeIterator.nextNode();
                if (node.isNodeType("exo:webContent") || node.isNodeType("exo:hiddenable") || !node.isNodeType("exo:taxonomy") && !node.isNodeType("nt:unstructured") && !node.isNodeType("nt:folder")) continue;
                StringBuilder buffer = new StringBuilder(128);
                buffer.append(node.getName());
                index = node.getIndex();
                if (index > 1) {
                    buffer.append('[');
                    buffer.append(index);
                    buffer.append(']');
                }
                Element childNode = document.createElement("childNode");
                parentNode.appendChild(childNode);
                Element workSpaceEle = document.createElement("workspaceName");
                workSpaceEle.setTextContent(workspaceName);
                Element repositoryEle = document.createElement("repositoryName");
                repositoryEle.setTextContent(repositoryName);
                Element nameEle = document.createElement("name");
                nameEle.setTextContent(buffer.toString());
                Element nodePathEle = document.createElement("nodePath");
                nodePathEle.setTextContent(node.getPath());
                childNode.appendChild(workSpaceEle);
                childNode.appendChild(repositoryEle);
                childNode.appendChild(nameEle);
                childNode.appendChild(nodePathEle);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
    }
}

