/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.UINodeTree;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UINodeTreeBuilder
extends UIContainer {
    private String[] acceptedNodeTypes = new String[0];
    protected Node rootTreeNode;
    protected Node currentNode;

    public UINodeTreeBuilder() throws Exception {
        UITree tree = (UITree)this.addChild(UINodeTree.class, null, UINodeTree.class.getSimpleName() + ((Object)((Object)this)).hashCode());
        tree.setBeanLabelField("name");
        tree.setBeanIdField("path");
    }

    public Node getRootTreeNode() {
        return this.rootTreeNode;
    }

    public final void setRootTreeNode(Node node) throws Exception {
        this.rootTreeNode = node;
        this.currentNode = node;
        this.broadcastOnChange(node, null);
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    public String[] getAcceptedNodeTypes() {
        return this.acceptedNodeTypes;
    }

    public void setAcceptedNodeTypes(String[] acceptedNodeTypes) {
        this.acceptedNodeTypes = acceptedNodeTypes;
    }

    public void buildTree() throws Exception {
        NodeIterator sibbling = null;
        NodeIterator children = null;
        UINodeTree tree = (UINodeTree)this.getChild(UINodeTree.class);
        tree.setSelected(this.currentNode);
        if (this.currentNode.getDepth() > 0) {
            tree.setParentSelected(this.currentNode.getParent());
            sibbling = this.currentNode.getNodes();
            children = this.currentNode.getNodes();
        } else {
            tree.setParentSelected(this.currentNode);
            sibbling = this.currentNode.getNodes();
            children = null;
        }
        if (sibbling != null) {
            tree.setSibbling(this.filfer(sibbling));
        }
        if (children != null) {
            tree.setChildren(this.filfer(children));
        }
    }

    private List<Node> filfer(NodeIterator iterator) throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.acceptedNodeTypes.length > 0) {
            block0: while (iterator.hasNext()) {
                Node sibbling = iterator.nextNode();
                if (sibbling.isNodeType("exo:hiddenable")) continue;
                for (String nodetype : this.acceptedNodeTypes) {
                    if (!sibbling.isNodeType(nodetype)) continue;
                    list.add(sibbling);
                    continue block0;
                }
            }
            return list;
        }
        while (iterator.hasNext()) {
            Node sibbling = iterator.nextNode();
            if (sibbling.isNodeType("exo:hiddenable")) continue;
            list.add(sibbling);
        }
        return list;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer writer = context.getWriter();
        writer.write("<div class=\"Explorer\">");
        writer.write("<div class=\"ExplorerTree\">");
        writer.write("<div class=\"InnerExplorerTree\">");
        this.buildTree();
        super.renderChildren();
        writer.write("</div>");
        writer.write("</div>");
        writer.write("</div>");
    }

    public void changeNode(String path, Object context) throws Exception {
        String rootPath = this.rootTreeNode.getPath();
        this.currentNode = rootPath.equals(path) || !path.startsWith(rootPath) ? this.rootTreeNode : (Node)this.rootTreeNode.getSession().getItem(path);
        this.broadcastOnChange(this.currentNode, context);
    }

    public void broadcastOnChange(Node node, Object context) throws Exception {
        UIBaseNodeTreeSelector nodeTreeSelector = (UIBaseNodeTreeSelector)this.getAncestorOfType(UIBaseNodeTreeSelector.class);
        nodeTreeSelector.onChange(node, context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            UINodeTreeBuilder builder = (UINodeTreeBuilder)((UITree)event.getSource()).getParent();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            builder.changeNode(uri, event.getRequestContext());
            UIBaseNodeTreeSelector nodeTreeSelector = (UIBaseNodeTreeSelector)builder.getAncestorOfType(UIBaseNodeTreeSelector.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)nodeTreeSelector);
        }
    }
}

