/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form.validator;

import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class StandardNameValidator
implements Validator {
    public void validate(UIFormInput uiInput) throws Exception {
        String inputValue = ((String)uiInput.getValue()).trim();
        if (inputValue == null || inputValue.length() == 0) {
            this.throwException("ECMStandardPropertyNameValidator.msg.empty-input", uiInput);
        }
        switch (inputValue.length()) {
            case 1: {
                this.checkOneChar(inputValue, uiInput);
                break;
            }
            case 2: {
                this.checkTwoChars(inputValue, uiInput);
            }
            default: {
                this.checkMoreChars(inputValue, uiInput);
            }
        }
    }

    public boolean checkArr(String s, String[] arrFilterChars) {
        for (String filter : arrFilterChars) {
            if (!s.equals(filter)) continue;
            return true;
        }
        return false;
    }

    public void checkOneChar(String s, UIFormInput uiInput) throws MessageException {
        String[] arrFilterChars = new String[]{".", "/", ":", "[", "]", "*", "'", "|", "\""};
        if (this.checkArr(s, arrFilterChars)) {
            this.throwException("ECMStandardPropertyNameValidator.msg.Invalid-char", uiInput);
        }
    }

    public void checkTwoChars(String s, UIFormInput uiInput) throws MessageException {
        String s2 = "";
        if (s.startsWith(".")) {
            s2 = s.substring(1, 2);
            this.checkOneChar(s2, uiInput);
        } else if (s.endsWith(".")) {
            s2 = s.substring(0, 1);
            this.checkOneChar(s2, uiInput);
        } else {
            String s3 = s.substring(0, 1);
            String s4 = s.substring(1, 2);
            String[] arrFilterChars = new String[]{".", "/", ":", "[", "]", "*", "'", "|", "\""};
            if (this.checkArr(s3, arrFilterChars)) {
                this.throwException("ECMStandardPropertyNameValidator.msg.Invalid-char", uiInput);
            } else if (this.checkArr(s4, arrFilterChars)) {
                this.throwException("ECMStandardPropertyNameValidator.msg.Invalid-char", uiInput);
            }
        }
    }

    public void checkMoreChars(String s, UIFormInput uiInput) throws MessageException {
        String[] arrFilterChars = new String[]{"/", ":", "[", "]", "*", "'", "|", "\""};
        String s1 = s.substring(0, 1);
        String s2 = s.substring(s.length() - 1, s.length());
        if (this.checkArr(s1, arrFilterChars)) {
            this.throwException("ECMStandardPropertyNameValidator.msg.Invalid-char", uiInput);
        } else if (this.checkArr(s2, arrFilterChars)) {
            this.throwException("ECMStandardPropertyNameValidator.msg.Invalid-char", uiInput);
        } else {
            String s3 = s.substring(1, s.length() - 1);
            for (String filterChar : arrFilterChars) {
                if (s3.indexOf(filterChar) <= -1) continue;
                this.throwException("ECMStandardPropertyNameValidator.msg.Invalid-char", uiInput);
            }
        }
    }

    public void throwException(String s, UIFormInput uiInput) throws MessageException {
        Object[] args = new Object[]{uiInput.getName()};
        throw new MessageException(new ApplicationMessage(s, args, 1));
    }

    public static void main(String[] args) {
        String s = ".xyzs";
        String s2 = s.substring(1, 2);
        String s3 = s.substring(0, s.length() - 1);
        String s4 = s.substring(s.length() - 1, s.length());
        String s5 = s.substring(1, s.length() - 1);
        System.out.println(s2);
        System.out.println(s3);
        System.out.println(s4);
        System.out.println(s5);
    }
}

