/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.benchmark.preparation.repository;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.wcm.benchmark.preparation.repository.RepoloadWorker;
import org.picocontainer.Startable;

public class RepoloadServiceImpl
implements Startable {
    protected Log log = ExoLogger.getLogger((String)"repload.RepoloadService");
    protected RepositoryService repositoryService = null;
    protected Node rootNode;
    protected int fileSize = 0;
    protected int l1Count = 0;
    protected int l2Count = 0;
    protected int l3Count = 0;
    protected int l4Count = 0;
    protected String mimeType = null;
    protected String repository = null;
    protected String root = null;
    protected String workspace = null;
    protected int firstWord = 10;
    protected int secondWord = 10;
    protected int startIndex = 10;
    private final Random random;
    private int spetialTitlesCount = 7;

    public RepoloadServiceImpl(InitParams params, RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        PropertiesParam propertiesParam = params.getPropertiesParam("repoload.configuration");
        this.fileSize = Integer.parseInt(propertiesParam.getProperty("fileSize"));
        this.l1Count = Integer.parseInt(propertiesParam.getProperty("l1Count"));
        this.l2Count = Integer.parseInt(propertiesParam.getProperty("l2Count"));
        this.l3Count = Integer.parseInt(propertiesParam.getProperty("l3Count"));
        this.l4Count = Integer.parseInt(propertiesParam.getProperty("l4Count"));
        this.mimeType = propertiesParam.getProperty("mimeType");
        this.repository = propertiesParam.getProperty("repository");
        this.root = propertiesParam.getProperty("root");
        this.workspace = propertiesParam.getProperty("workspace");
        this.random = new Random();
    }

    public RepoloadServiceImpl(int fSize, int l1Count, int l2Count, int l3Count, int l4Count, String mimeType, String repository, String root, String workspace, RepositoryService repositoryService, int firstWord, int secondWord, int startIndex, int spetialTitlesCount) {
        this.repositoryService = repositoryService;
        this.fileSize = fSize;
        this.l1Count = l1Count;
        this.l2Count = l2Count;
        this.l3Count = l3Count;
        this.l4Count = l4Count;
        this.mimeType = mimeType;
        this.repository = repository;
        this.root = root;
        this.workspace = workspace;
        this.firstWord = firstWord;
        this.secondWord = secondWord;
        this.startIndex = startIndex;
        this.spetialTitlesCount = spetialTitlesCount;
        this.random = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRootTree() {
        Session session = null;
        try {
            session = this.repositoryService.getRepository(this.repository).getSystemSession(this.workspace);
            if (!session.itemExists(this.root)) {
                this.log.info((Object)"Creating the root tree");
                String[] paths = this.root.split("/");
                this.rootNode = session.getRootNode();
                for (int i = 1; i < paths.length; ++i) {
                    this.rootNode = this.rootNode.hasNode(paths[i]) ? this.rootNode.getNode(paths[i]) : this.rootNode.addNode(paths[i]);
                }
            } else {
                this.rootNode = (Node)session.getItem(this.root);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception while creating the tree node", (Throwable)e);
        }
        finally {
            try {
                session.save();
                session.logout();
            }
            catch (Exception exception) {}
        }
    }

    public void start() {
        try {
            long before = System.currentTimeMillis();
            this.createRootTree();
            Thread[] workers = new Thread[this.l1Count];
            CountDownLatch loch = new CountDownLatch(this.l1Count);
            boolean[] map = this.parseBitMap(this.l1Count * this.l2Count * this.l3Count * this.l4Count, this.spetialTitlesCount);
            for (int l1 = 0; l1 < this.l1Count; ++l1) {
                workers[l1] = new RepoloadWorker(this, l1, this.firstWord, this.secondWord, this.startIndex, map, loch);
                workers[l1].start();
            }
            loch.await();
            int totalDocumentLoaded = 0;
            int totlaSpetialTitle = 0;
            for (int i = 0; i < workers.length; ++i) {
                totalDocumentLoaded += ((RepoloadWorker)workers[i]).getTotalFile();
                totlaSpetialTitle += ((RepoloadWorker)workers[i]).getSpetialTitleCount();
            }
            this.log.info((Object)(totalDocumentLoaded + " documents loaded in " + (System.currentTimeMillis() - before) / 60000L + " minutes. Spetial titles" + totlaSpetialTitle));
        }
        catch (Exception e) {
            this.log.error((Object)"Exception while starting the Repoload service", (Throwable)e);
        }
    }

    public void stop() {
    }

    public boolean[] parseBitMap(int documents, int titles) {
        boolean[] map = new boolean[documents];
        for (int i = 0; i < titles; ++i) {
            int position = this.random.nextInt(documents);
            if (map[position]) {
                --i;
                continue;
            }
            map[position] = true;
        }
        return map;
    }

    public Node getRootNode() {
        return this.rootNode;
    }
}

