/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.deployment.WCMContentInitializerService;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.config.NewsletterUserConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.picocontainer.Startable;

public class NewsletterInitializationService
implements Startable {
    private List<String> portalNames;
    private List<NewsletterCategoryConfig> categoryConfigs;
    private List<NewsletterSubscriptionConfig> subscriptionConfigs;
    private List<NewsletterUserConfig> userConfigs;
    private NewsletterManagerService newsletterManagerService;
    private LivePortalManagerService livePortalManagerService;
    private static Log log = ExoLogger.getLogger(NewsletterInitializationService.class);

    public NewsletterInitializationService(InitParams initParams, NewsletterManagerService newsletterManagerService, LivePortalManagerService livePortalManagerService, WCMContentInitializerService wcmContentInitializerService) {
        this.portalNames = initParams.getValuesParam("portalNames").getValues();
        this.categoryConfigs = initParams.getObjectParamValues(NewsletterCategoryConfig.class);
        this.subscriptionConfigs = initParams.getObjectParamValues(NewsletterSubscriptionConfig.class);
        this.userConfigs = initParams.getObjectParamValues(NewsletterUserConfig.class);
        this.livePortalManagerService = livePortalManagerService;
        this.newsletterManagerService = newsletterManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        log.info((Object)"Starting NewsletterInitializationService ... ");
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node dummyNode = this.livePortalManagerService.getLivePortal(this.portalNames.get(0), sessionProvider);
            Session session = dummyNode.getSession();
            Node serviceFolder = session.getRootNode().getNode("exo:services");
            Node newsletterInitializationService = null;
            newsletterInitializationService = serviceFolder.hasNode("NewsletterInitializationService") ? serviceFolder.getNode("NewsletterInitializationService") : serviceFolder.addNode("NewsletterInitializationService", "nt:unstructured");
            if (!newsletterInitializationService.hasNode("NewsletterInitializationServiceLog")) {
                for (String portalName : this.portalNames) {
                    NewsletterCategoryHandler categoryHandler = this.newsletterManagerService.getCategoryHandler();
                    for (NewsletterCategoryConfig categoryConfig : this.categoryConfigs) {
                        categoryHandler.add(portalName, categoryConfig, sessionProvider);
                    }
                    NewsletterSubscriptionHandler subscriptionHandler = this.newsletterManagerService.getSubscriptionHandler();
                    for (NewsletterSubscriptionConfig subscriptionConfig : this.subscriptionConfigs) {
                        subscriptionHandler.add(sessionProvider, portalName, subscriptionConfig);
                    }
                    Node userNode = null;
                    NewsletterManageUserHandler manageUserHandler = this.newsletterManagerService.getManageUserHandler();
                    for (NewsletterUserConfig userConfig : this.userConfigs) {
                        userNode = manageUserHandler.add(portalName, userConfig.getMail(), sessionProvider);
                    }
                    ExtendedNode userFolderNode = (ExtendedNode)userNode.getParent();
                    if (userFolderNode.canAddMixin("exo:privilegeable")) {
                        userFolderNode.addMixin("exo:privilegeable");
                    }
                    userFolderNode.setPermission("any", PermissionType.ALL);
                    Node newsletterInitializationServiceLog = newsletterInitializationService.addNode("NewsletterInitializationServiceLog", "nt:file");
                    Node newsletterInitializationServiceLogContent = newsletterInitializationServiceLog.addNode("jcr:content", "nt:resource");
                    newsletterInitializationServiceLogContent.setProperty("jcr:encoding", "UTF-8");
                    newsletterInitializationServiceLogContent.setProperty("jcr:mimeType", "text/plain");
                    newsletterInitializationServiceLogContent.setProperty("jcr:data", "Newsletter was created successfully");
                    newsletterInitializationServiceLogContent.setProperty("jcr:lastModified", new Date().getTime());
                    session.save();
                }
            }
        }
        catch (Throwable e) {
            log.info((Object)("Starting NewsletterInitializationService fail because of " + e.getMessage()));
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
        log.info((Object)"Stopping NewsletterInitializationService ... ");
    }
}

