/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.defaultlifecycle;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.defaultlifecycle.Util;
import org.exoplatform.services.wcm.publication.defaultlifecycle.WCMPublicationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEventListenerDelegate {
    private String lifecycleName;

    public PageEventListenerDelegate(String lifecycleName, ExoContainer container) {
        this.lifecycleName = lifecycleName;
    }

    public void updateLifecyleOnCreatePage(Page page) throws Exception {
        this.updateAddedApplication(page);
    }

    public void updateLifecyleOnChangePage(Page page) throws Exception {
        this.updateAddedApplication(page);
        this.updateRemovedApplication(page);
    }

    public void updateLifecycleOnRemovePage(Page page) throws Exception {
        List<String> listPageApplicationId = Util.getListApplicationIdByPage(page);
        for (String applicationId : listPageApplicationId) {
            Node content = Util.getNodeByApplicationId(applicationId);
            if (content == null) continue;
            this.saveRemovedApplication(page, applicationId, content);
        }
    }

    private void updateAddedApplication(Page page) throws Exception {
        List<String> listPageApplicationId = Util.getListApplicationIdByPage(page);
        for (String applicationtId : listPageApplicationId) {
            Node content = Util.getNodeByApplicationId(applicationtId);
            if (content == null) continue;
            this.saveAddedApplication(page, applicationtId, content, this.lifecycleName);
        }
    }

    private void updateRemovedApplication(Page page) throws Exception {
        List<Node> listNode = this.getListNodeByApplicationId(page);
        List<String> listApplicationId = Util.getListApplicationIdByPage(page);
        for (Node content : listNode) {
            for (Value value : content.getProperty("publication:applicationIDs").getValues()) {
                String[] tmp = Util.parseMixedApplicationId(value.getString());
                String nodeApplicationId = tmp[1];
                if (!tmp[0].equals(page.getPageId()) || listApplicationId.contains(nodeApplicationId)) continue;
                this.saveRemovedApplication(page, nodeApplicationId, content);
            }
        }
    }

    private List<Node> getListNodeByApplicationId(Page page) throws Exception {
        RepositoryService repositoryService = Util.getServices(RepositoryService.class);
        WCMConfigurationService configurationService = Util.getServices(WCMConfigurationService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        NodeLocation nodeLocation = configurationService.getLivePortalsLocation(repository.getConfiguration().getName());
        String repositoryName = nodeLocation.getRepository();
        String workspaceName = nodeLocation.getWorkspace();
        String path = nodeLocation.getPath();
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        Session session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repositoryName));
        ArrayList<Node> listPublishedNode = new ArrayList<Node>();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from publication:wcmPublication where publication:lifecycleName='" + this.lifecycleName + "' and publication:webPageIDs like '%" + page.getPageId() + "%' and jcr:path like '" + path + "/%' order by jcr:score", "sql");
        QueryResult results = query.execute();
        NodeIterator nodeIterator = results.getNodes();
        while (nodeIterator.hasNext()) {
            listPublishedNode.add(nodeIterator.nextNode());
        }
        return listPublishedNode;
    }

    private void saveAddedApplication(Page page, String applicationId, Node content, String lifecycleName) throws Exception {
        String mixedAppId;
        PublicationService publicationService = Util.getServices(PublicationService.class);
        String nodeLifecycleName = null;
        try {
            nodeLifecycleName = publicationService.getNodeLifecycleName(content);
        }
        catch (NotInPublicationLifecycleException e) {
            return;
        }
        if (!lifecycleName.equals(nodeLifecycleName)) {
            return;
        }
        WCMPublicationService presentationService = Util.getServices(WCMPublicationService.class);
        WCMPublicationPlugin publicationPlugin = (WCMPublicationPlugin)presentationService.getWebpagePublicationPlugins().get(WCMPublicationPlugin.LIFECYCLE_NAME);
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> nodeAppIds = Util.getValuesAsString(content, "publication:applicationIDs");
        if (nodeAppIds.contains(mixedAppId = Util.setMixedApplicationId(page.getPageId(), applicationId))) {
            return;
        }
        List<String> listExistedNavigationNodeUri = Util.getValuesAsString(content, "publication:navigationNodeURIs");
        String nodeURILogs = "";
        List<String> listPageNavigationUri = publicationPlugin.getListPageNavigationUri(page);
        if (listPageNavigationUri.isEmpty()) {
            return;
        }
        for (String uri : listPageNavigationUri) {
            if (!listExistedNavigationNodeUri.contains(uri)) {
                listExistedNavigationNodeUri.add(uri);
            }
            nodeURILogs = nodeURILogs + uri + "; ";
        }
        content.setProperty("publication:navigationNodeURIs", Util.toValues(valueFactory, listExistedNavigationNodeUri));
        List<String> nodeWebPageIds = Util.getValuesAsString(content, "publication:webPageIDs");
        nodeWebPageIds.add(page.getPageId());
        nodeAppIds.add(mixedAppId);
        content.setProperty("publication:applicationIDs", Util.toValues(valueFactory, nodeAppIds));
        content.setProperty("publication:webPageIDs", Util.toValues(valueFactory, nodeWebPageIds));
        publicationPlugin.changeState(content, "published", null);
        String[] logs = new String[]{new Date().toString(), WCMPublicationPlugin.PUBLISHED, session.getUserID(), "PublicationService.WCMPublicationPlugin.nodePublished", nodeURILogs};
        publicationService.addLog(content, logs);
        session.save();
    }

    private void saveRemovedApplication(Page page, String applicationId, Node content) throws Exception {
        WCMPublicationService presentationService = Util.getServices(WCMPublicationService.class);
        PublicationService publicationService = Util.getServices(PublicationService.class);
        WCMPublicationPlugin publicationPlugin = (WCMPublicationPlugin)presentationService.getWebpagePublicationPlugins().get(WCMPublicationPlugin.LIFECYCLE_NAME);
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedApplicationId = Util.getValuesAsString(content, "publication:applicationIDs");
        listExistedApplicationId.remove(Util.setMixedApplicationId(page.getPageId(), applicationId));
        content.setProperty("publication:applicationIDs", Util.toValues(valueFactory, listExistedApplicationId));
        List<String> listExistedPageId = Util.getValuesAsString(content, "publication:webPageIDs");
        listExistedPageId.remove(0);
        content.setProperty("publication:webPageIDs", Util.toValues(valueFactory, listExistedPageId));
        List<String> listPageNavigationUri = publicationPlugin.getListPageNavigationUri(page);
        List<String> listExistedNavigationNodeUri = Util.getValuesAsString(content, "publication:navigationNodeURIs");
        ArrayList<String> listExistedNavigationNodeUriTmp = new ArrayList<String>();
        listExistedNavigationNodeUriTmp.addAll(listExistedNavigationNodeUri);
        for (String existedNavigationNodeUri : listExistedNavigationNodeUriTmp) {
            if (!listPageNavigationUri.contains(existedNavigationNodeUri)) continue;
            listExistedNavigationNodeUri.remove(existedNavigationNodeUri);
        }
        content.setProperty("publication:navigationNodeURIs", Util.toValues(valueFactory, listExistedNavigationNodeUri));
        String uris = "";
        for (String uri : listPageNavigationUri) {
            uris = uris + uri + "; ";
        }
        String[] logs = new String[]{new Date().toString(), WCMPublicationPlugin.PUBLISHED, session.getUserID(), "PublicationService.WCMPublicationPlugin.nodeRemoved", uris};
        publicationService.addLog(content, logs);
        if (listExistedPageId.isEmpty()) {
            publicationPlugin.changeState(content, "unpublished", null);
        }
        session.save();
    }
}

