/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.defaultlifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.services.wcm.publication.defaultlifecycle.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;

@ComponentConfig(template="system:/groovy/webui/core/UITree.gtmpl")
public class UIPublicationTree
extends UITree {
    public String event(String name, String beanId) throws Exception {
        UIComponent component = this.getParent();
        return component.event(name, beanId);
    }

    public String getActionLink() throws Exception {
        if (this.getSelected() == null) {
            return "javascript:void(0)";
        }
        if (this.getParentSelected() == null) {
            return "javascript:void(0)";
        }
        return this.event("ChangeNode", (String)this.getId(this.getParentSelected()));
    }

    public boolean isSelected(Object obj) throws Exception {
        TreeNode selected = (TreeNode)this.getSelected();
        if (selected == null) {
            return false;
        }
        TreeNode compared = (TreeNode)TreeNode.class.cast(obj);
        return compared.getUri().equals(selected.getUri());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeNode {
        private String portalName;
        private boolean isPageNode;
        private PageNode pageNode;
        private PageNavigation navigation;
        private List<TreeNode> children;
        private ResourceBundle resourceBundle;

        public TreeNode(String portalName, PageNavigation navigation, ResourceBundle res, boolean isPageNode) {
            this.portalName = portalName;
            this.navigation = navigation;
            this.resourceBundle = res;
            this.isPageNode = isPageNode;
        }

        public String getUri() {
            if (this.isPageNode) {
                return "/" + this.portalName + "/" + this.pageNode.getUri();
            }
            return "/" + this.portalName;
        }

        public String getPageNodeUri() {
            if (this.isPageNode) {
                return this.pageNode.getUri();
            }
            return null;
        }

        public String getIcon() {
            if (!this.isPageNode) {
                return "";
            }
            return this.pageNode.getIcon();
        }

        public List<TreeNode> getTreeNodeChildren() {
            return this.children;
        }

        public void setTreeNodeChildren(List<TreeNode> list) {
            this.children = list;
        }

        public void setPageNode(PageNode pageNode) {
            this.pageNode = pageNode;
            this.pageNode.setResolvedLabel(this.resourceBundle);
            if (pageNode.getChildren() == null) {
                this.children = null;
            }
        }

        public boolean isPageNode() {
            return this.isPageNode;
        }

        public void setIsPageNode(boolean isPageNode) {
            this.isPageNode = isPageNode;
        }

        public String getName() {
            if (this.isPageNode) {
                return this.pageNode.getName();
            }
            return this.portalName;
        }

        public String getResolvedLabel() {
            if (this.isPageNode) {
                return this.pageNode.getResolvedLabel();
            }
            return this.portalName;
        }

        public void setPortalName(String s) {
            this.portalName = s;
        }

        public String getPortalName() {
            return this.portalName;
        }

        public void setChildrenByPageNodes(List<PageNode> pagesNodes) throws Exception {
            if (pagesNodes == null) {
                return;
            }
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            UserPortalConfigService userPortalConfigService = Util.getServices(UserPortalConfigService.class);
            for (PageNode pNode : pagesNodes) {
                Page page = userPortalConfigService.getPage(pNode.getPageReference(), org.exoplatform.portal.webui.util.Util.getPortalRequestContext().getRemoteUser());
                if (page == null || !pNode.isDisplay()) continue;
                TreeNode treeNode = new TreeNode(this.portalName, this.navigation, this.resourceBundle, true);
                treeNode.setPageNode(pNode);
                treeNode.setChildrenByPageNodes(pNode.getChildren());
                list.add(treeNode);
            }
            this.setTreeNodeChildren(list);
        }

        public TreeNode searchTreeNodeByURI(String uri) throws Exception {
            if (uri.equals("/" + this.portalName)) {
                TreeNode treeNode = new TreeNode(this.portalName, this.navigation, this.resourceBundle, false);
                treeNode.setChildrenByPageNodes(this.navigation.getNodes());
                return treeNode;
            }
            String pageNodeURI = StringUtils.substringAfter((String)uri, (String)("/" + this.portalName + "/"));
            PageNode other = PageNavigationUtils.searchPageNodeByUri((PageNavigation)this.navigation, (String)pageNodeURI);
            if (other == null) {
                return null;
            }
            TreeNode treeNode = new TreeNode(this.portalName, this.navigation, this.resourceBundle, true);
            treeNode.setPageNode(other);
            treeNode.setChildrenByPageNodes(other.getChildren());
            return treeNode;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public PageNavigation getNavigation() {
            return this.navigation;
        }

        public PageNode getPageNode() {
            return this.pageNode;
        }
    }
}

