/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.simple;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.lifecycle.simple.SimplePublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.simple.Util;

public class NavigationEventListenerDelegate {
    private String lifecycleName;

    public NavigationEventListenerDelegate(String lifecycleName, ExoContainer container) {
        this.lifecycleName = lifecycleName;
    }

    public void updateLifecyleOnCreateNavigation(PageNavigation pageNavigation) throws Exception {
    }

    public void updateLifecycleOnChangeNavigation(PageNavigation pageNavigation) throws Exception {
        if (pageNavigation.getOwnerType().equals("portal")) {
            this.updateRemovedPageNode(pageNavigation);
            this.updateAddedPageNode(pageNavigation);
        }
    }

    public void updateLifecyleOnRemoveNavigation(PageNavigation pageNavigation) throws Exception {
    }

    private void updateAddedPageNode(PageNavigation pageNavigation) throws Exception {
        UserPortalConfigService userPortalConfigService = Util.getServices(UserPortalConfigService.class);
        for (PageNode pageNode : pageNavigation.getNodes()) {
            Page page = userPortalConfigService.getPage(pageNode.getPageReference(), org.exoplatform.portal.webui.util.Util.getPortalRequestContext().getRemoteUser());
            if (page == null) continue;
            for (String applicationId : Util.getListApplicationIdByPage(page)) {
                List<String> listExistedApplicationId;
                Node content = Util.getNodeByApplicationId(applicationId);
                if (content == null || (listExistedApplicationId = Util.getValuesAsString(content, "publication:applicationIDs")).contains(Util.setMixedApplicationId(page.getPageId(), applicationId))) continue;
                this.saveAddedPageNode(pageNavigation.getOwnerId(), pageNode, applicationId, content);
            }
        }
    }

    private void updateRemovedPageNode(PageNavigation pageNavigation) throws Exception {
        String portalName = pageNavigation.getOwnerId();
        ArrayList listPortalPageNode = pageNavigation.getNodes();
        ArrayList<String> listPortalNavigationUri = new ArrayList<String>();
        ArrayList<String> listPageReference = new ArrayList<String>();
        for (PageNode portalPageNode : listPortalPageNode) {
            String mixedNavigationNodeUri = Util.setMixedNavigationUri(portalName, portalPageNode.getUri());
            listPortalNavigationUri.add(mixedNavigationNodeUri);
            listPageReference.add(portalPageNode.getPageReference());
        }
        RepositoryService repositoryService = Util.getServices(RepositoryService.class);
        WCMConfigurationService configurationService = Util.getServices(WCMConfigurationService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        NodeLocation nodeLocation = configurationService.getLivePortalsLocation(repository.getConfiguration().getName());
        String repositoryName = nodeLocation.getRepository();
        String workspaceName = nodeLocation.getWorkspace();
        String path = nodeLocation.getPath();
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        Session session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repositoryName));
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from publication:simplePublication where publication:lifecycleName='" + this.lifecycleName + "' and jcr:path like '" + path + "/%' order by jcr:score", "sql");
        QueryResult results = query.execute();
        NodeIterator nodeIterator = results.getNodes();
        while (nodeIterator.hasNext()) {
            Node content = nodeIterator.nextNode();
            String navigationNodeUri = "";
            for (String existedNavigationNodeUri : Util.getValuesAsString(content, "publication:navigationNodeURIs")) {
                if (!existedNavigationNodeUri.startsWith("/" + portalName) || listPortalNavigationUri.contains(existedNavigationNodeUri)) continue;
                navigationNodeUri = existedNavigationNodeUri;
            }
            String pageId = "";
            for (String existedPageId : Util.getValuesAsString(content, "publication:webPageIDs")) {
                if (listPageReference.contains(existedPageId) || listPortalNavigationUri.contains(navigationNodeUri)) continue;
                pageId = existedPageId;
            }
            if (pageId.equals("")) continue;
            String applicationId = "";
            UserPortalConfigService userPortalConfigService = Util.getServices(UserPortalConfigService.class);
            Page page = userPortalConfigService.getPage(pageId, org.exoplatform.portal.webui.util.Util.getPortalRequestContext().getRemoteUser());
            for (String applicationIdTmp : Util.getListApplicationIdByPage(page)) {
                applicationIdTmp = Util.setMixedApplicationId(pageId, applicationIdTmp);
                List<String> listExistedApplicationId = Util.getValuesAsString(content, "publication:applicationIDs");
                if (!listExistedApplicationId.contains(applicationIdTmp)) continue;
                applicationId = applicationIdTmp;
            }
            this.saveRemovedPageNode(navigationNodeUri, pageId, applicationId, content);
        }
    }

    private void saveAddedPageNode(String portalName, PageNode pageNode, String applicationId, Node content) throws Exception {
        String mixedApplicationId;
        PublicationService publicationService = Util.getServices(PublicationService.class);
        String nodeLifecycleName = null;
        try {
            nodeLifecycleName = publicationService.getNodeLifecycleName(content);
        }
        catch (NotInPublicationLifecycleException e) {
            return;
        }
        if (!this.lifecycleName.equals(nodeLifecycleName)) {
            return;
        }
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedApplicationId = Util.getValuesAsString(content, "publication:applicationIDs");
        if (listExistedApplicationId.contains(mixedApplicationId = Util.setMixedApplicationId(pageNode.getPageReference(), applicationId))) {
            return;
        }
        listExistedApplicationId.add(mixedApplicationId);
        content.setProperty("publication:applicationIDs", Util.toValues(valueFactory, listExistedApplicationId));
        List<String> listExistedNavigationNodeUri = Util.getValuesAsString(content, "publication:navigationNodeURIs");
        String mixedNavigationNodeUri = Util.setMixedNavigationUri(portalName, pageNode.getUri());
        listExistedNavigationNodeUri.add(mixedNavigationNodeUri);
        String nodeURILogs = mixedNavigationNodeUri + "; ";
        content.setProperty("publication:navigationNodeURIs", Util.toValues(valueFactory, listExistedNavigationNodeUri));
        List<String> listExistedWebPageId = Util.getValuesAsString(content, "publication:webPageIDs");
        listExistedWebPageId.add(pageNode.getPageReference());
        content.setProperty("publication:webPageIDs", Util.toValues(valueFactory, listExistedWebPageId));
        WCMPublicationService presentationService = Util.getServices(WCMPublicationService.class);
        SimplePublicationPlugin publicationPlugin = (SimplePublicationPlugin)presentationService.getWebpagePublicationPlugins().get(SimplePublicationPlugin.LIFECYCLE_NAME);
        publicationPlugin.changeState(content, "published", null);
        String[] logs = new String[]{new Date().toString(), "published", session.getUserID(), "PublicationService.WCMPublicationPlugin.nodePublished", nodeURILogs};
        publicationService.addLog(content, logs);
        session.save();
    }

    private void saveRemovedPageNode(String navigationNodeUri, String pageId, String applicationId, Node content) throws Exception {
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedNavigationNodeUri = Util.getValuesAsString(content, "publication:navigationNodeURIs");
        List<String> listExistedNavigationNodeUriTmp = Util.getValuesAsString(content, "publication:navigationNodeURIs");
        if (listExistedNavigationNodeUri.contains(navigationNodeUri)) {
            listExistedNavigationNodeUriTmp.remove(navigationNodeUri);
        }
        content.setProperty("publication:navigationNodeURIs", Util.toValues(valueFactory, listExistedNavigationNodeUriTmp));
        List<String> listExistedPageId = Util.getValuesAsString(content, "publication:webPageIDs");
        List<String> listExistedPageIdTmp = Util.getValuesAsString(content, "publication:webPageIDs");
        if (listExistedPageId.contains(pageId)) {
            listExistedPageIdTmp.remove(pageId);
        }
        content.setProperty("publication:webPageIDs", Util.toValues(valueFactory, listExistedPageIdTmp));
        List<String> listExistedApplicationId = Util.getValuesAsString(content, "publication:applicationIDs");
        List<String> listExistedApplicationIdTmp = Util.getValuesAsString(content, "publication:applicationIDs");
        if (listExistedApplicationId.contains(applicationId)) {
            listExistedApplicationIdTmp.remove(applicationId);
        }
        content.setProperty("publication:applicationIDs", Util.toValues(valueFactory, listExistedApplicationIdTmp));
        String nodeURILogs = "";
        if (!navigationNodeUri.equals("")) {
            nodeURILogs = navigationNodeUri + "; ";
            String[] logs = new String[]{new Date().toString(), "published", session.getUserID(), "PublicationService.WCMPublicationPlugin.nodeRemoved", nodeURILogs};
            PublicationService publicationService = Util.getServices(PublicationService.class);
            publicationService.addLog(content, logs);
        }
        if (listExistedNavigationNodeUriTmp.isEmpty()) {
            WCMPublicationService presentationService = Util.getServices(WCMPublicationService.class);
            SimplePublicationPlugin publicationPlugin = (SimplePublicationPlugin)presentationService.getWebpagePublicationPlugins().get(SimplePublicationPlugin.LIFECYCLE_NAME);
            publicationPlugin.changeState(content, "unpublished", null);
        }
        session.save();
    }
}

