/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMComposerImpl
implements WCMComposer,
Startable {
    private TemplateService templateService;
    private ThreadLocalSessionProviderService threadLocalSessionProviderService;
    private RepositoryService repositoryService;
    private PublicationService publicationService;
    private WCMPublicationService wcmPublicationService = null;
    private String templatesFilter = null;
    private String repository;

    public WCMComposerImpl(TemplateService templateService, PublicationService publicationService) throws Exception {
        this.templateService = templateService;
        this.repository = "repository";
        this.publicationService = publicationService;
        this.init();
    }

    private void init() throws Exception {
        this.threadLocalSessionProviderService = (ThreadLocalSessionProviderService)ThreadLocalSessionProviderService.class.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ThreadLocalSessionProviderService.class));
        this.repositoryService = (RepositoryService)RepositoryService.class.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class));
    }

    private WCMPublicationService getWCMPublicationService() {
        if (this.wcmPublicationService == null) {
            this.wcmPublicationService = (WCMPublicationService)WCMPublicationService.class.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WCMPublicationService.class));
        }
        return this.wcmPublicationService;
    }

    @Override
    public Node getContent(String repository, String workspace, String path, HashMap<String, String> filters) throws Exception {
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        Node node = (Node)session.getItem(path);
        String lifecycleName = this.publicationService.getNodeLifecycleName(node);
        PublicationPlugin publicationPlugin = (PublicationPlugin)this.publicationService.getPublicationPlugins().get(lifecycleName);
        Node nodeView = publicationPlugin.getNodeView(node, new HashMap());
        String state = this.getWCMPublicationService().getContentState(node);
        String mode = filters.get("filter-mode");
        List<String> states = this.getAllowedStates(mode);
        if (states.contains(state)) {
            return nodeView;
        }
        return null;
    }

    @Override
    public NodeIterator getContents(String repository, String workspace, String path, HashMap<String, String> filters) throws Exception {
        String templatesFilter = this.getTemlatesSQLFilter();
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        QueryManager manager = session.getWorkspace().getQueryManager();
        String orderFilter = this.getOrderSQLFilter(filters);
        String mode = filters.get("filter-mode");
        String statement = "";
        statement = "select * from nt:base where jcr:path like '" + path + "/%' AND " + "NOT jcr:path like '" + path + "/%/%'" + " AND " + templatesFilter + " AND " + "NOT publication:currentState like '%' ";
        statement = "Live".equals(mode) ? statement + "OR publication:currentState = 'published'" : statement + "OR publication:currentState <> 'obsolete' AND publication:currentState <> 'archived'";
        statement = statement + orderFilter;
        Query query = manager.createQuery(statement, "sql");
        return query.execute().getNodes();
    }

    @Override
    public boolean updateContent(String repository, String workspace, String path, HashMap<String, String> filters) {
        return false;
    }

    @Override
    public boolean updateContents(String repository, String workspace, String path, HashMap<String, String> filters) {
        return false;
    }

    @Override
    public List<String> getAllowedStates(String mode) {
        ArrayList<String> states = new ArrayList<String>();
        if ("Live".equals(mode)) {
            states.add("published");
        } else if ("Edit".equals(mode)) {
            states.add("published");
            states.add("draft");
            states.add("pending");
            states.add("staged");
            states.add("approved");
        }
        return states;
    }

    public void start() {
    }

    public void stop() {
    }

    private String getTemlatesSQLFilter() {
        if (this.templatesFilter != null) {
            return this.templatesFilter;
        }
        try {
            List listDocumentTypes = this.templateService.getDocumentTemplates(this.repository);
            StringBuffer documentTypeClause = new StringBuffer();
            for (int i = 0; i < listDocumentTypes.size(); ++i) {
                String documentType = (String)listDocumentTypes.get(i);
                documentTypeClause.append("jcr:primaryType = '" + documentType + "'");
                if (i == listDocumentTypes.size() - 1) continue;
                documentTypeClause.append(" OR ");
            }
            this.templatesFilter = documentTypeClause.toString();
            return this.templatesFilter;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getOrderSQLFilter(HashMap<String, String> filters) {
        String orderQuery = " ORDER BY ";
        String orderBy = filters.get("filter-order-by");
        String orderType = filters.get("filter-order-type");
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "exo:title";
        }
        orderQuery = orderQuery + orderBy + " " + orderType;
        return orderQuery;
    }
}

