/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import javax.jcr.Node;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationState;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.services.wcm.search.QueryCriteria;

public class WCMPaginatedQueryResult
extends PaginatedQueryResult {
    private long queryTime;
    private String spellSuggestion;
    private QueryCriteria queryCriteria;

    public WCMPaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public WCMPaginatedQueryResult(QueryResult queryResult, QueryCriteria queryCriteria, int pageSize) throws Exception {
        super(queryResult, pageSize);
        this.queryCriteria = queryCriteria;
    }

    public void setQueryTime(long time) {
        this.queryTime = time;
    }

    public float getQueryTimeInSecond() {
        return (float)this.queryTime / 1000.0f;
    }

    public QueryCriteria getQueryCriteria() {
        return this.queryCriteria;
    }

    public void setQueryCriteria(QueryCriteria queryCriteria) {
        this.queryCriteria = queryCriteria;
    }

    protected Node filterNodeToDisplay(Node node) throws Exception {
        String primaryNodeType;
        Object[] contentTypes;
        Node displayNode = node;
        String revisionState = StageAndVersionPublicationState.getRevisionState((Node)node);
        if (revisionState == null || StageAndVersionPublicationState.OBSOLETE.equals(revisionState)) {
            return null;
        }
        if (node.getPath().contains("web contents/site artifacts")) {
            return null;
        }
        if (displayNode.isNodeType("nt:resource")) {
            displayNode = node.getParent();
        }
        if (displayNode.isNodeType("exo:htmlFile")) {
            Node parent = displayNode.getParent();
            if (this.queryCriteria.isSearchWebContent()) {
                if (parent.isNodeType("exo:webContent")) {
                    return parent;
                }
                return null;
            }
            if (parent.isNodeType("exo:webContent")) {
                return null;
            }
            return displayNode;
        }
        if (this.queryCriteria.isSearchWebContent()) {
            if (!this.queryCriteria.isSearchDocument() && !displayNode.isNodeType("exo:webContent")) {
                return null;
            }
            if (this.queryCriteria.isSearchWebpage() && !displayNode.isNodeType("publication:stateAndVersionBasedPublication")) {
                return null;
            }
        } else if (this.queryCriteria.isSearchWebpage()) {
            if (this.queryCriteria.isSearchDocument()) {
                return displayNode;
            }
            if (!displayNode.isNodeType("publication:webpagesPublication")) {
                return null;
            }
        }
        if ((contentTypes = this.queryCriteria.getContentTypes()) != null && contentTypes.length > 0 && !ArrayUtils.contains((Object[])contentTypes, (Object)(primaryNodeType = displayNode.getPrimaryNodeType().getName()))) {
            return null;
        }
        return displayNode;
    }

    public String getSpellSuggestion() {
        return this.spellSuggestion;
    }

    public void setSpellSuggestion(String spellSuggestion) {
        this.spellSuggestion = spellSuggestion;
    }
}

