/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core.impl;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;

public class WCMServiceImpl
implements WCMService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getReferencedContent(String repository, String workspace, String nodeIdentifier) throws Exception {
        if (repository == null || workspace == null || nodeIdentifier == null) {
            throw new ItemNotFoundException();
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        SessionProvider sessionProvider = null;
        sessionProvider = userId == null ? SessionProviderFactory.createAnonimProvider() : SessionProviderFactory.createSessionProvider();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        Node content = null;
        try {
            content = session.getNodeByUUID(nodeIdentifier);
        }
        catch (Exception e) {
            content = (Node)session.getItem(nodeIdentifier);
        }
        finally {
            sessionProvider.close();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getRootNode(String repository, String workspace) throws Exception {
        if (repository == null || workspace == null) {
            throw new ItemNotFoundException();
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        SessionProvider sessionProvider = null;
        sessionProvider = userId == null ? SessionProviderFactory.createAnonimProvider() : SessionProviderFactory.createSessionProvider();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        Node content = null;
        try {
            content = session.getRootNode();
        }
        finally {
            sessionProvider.close();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharedPortal(String portalName) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)container.getComponentInstanceOfType(LivePortalManagerService.class);
        boolean isShared = false;
        ThreadLocalSessionProviderService providerService = (ThreadLocalSessionProviderService)container.getComponentInstanceOfType(ThreadLocalSessionProviderService.class);
        SessionProvider sessionProvider = providerService.getSessionProvider(null);
        try {
            Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
            isShared = sharedPortal.getName().equals(portalName);
        }
        finally {
            sessionProvider.close();
        }
        return isShared;
    }
}

