/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.images;

import java.io.InputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.QueryTemplate;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;

@URITemplate(value="/images/{repositoryName}/{workspaceName}/{nodeIdentifier}/")
public class RESTImagesRendererService
implements ResourceContainer {
    private ThreadLocalSessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    static Log log = ExoLogger.getLogger(RESTImagesRendererService.class);
    private String baseRestURI = "/portal/rest/";

    public RESTImagesRendererService(RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    @HTTPMethod(value="GET")
    @QueryTemplate(value="type=file")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response serveImage(@URIParam(value="repositoryName") String repository, @URIParam(value="workspaceName") String workspace, @URIParam(value="nodeIdentifier") String nodeIdentifier) {
        Node node = null;
        try {
            SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
            Session session = sessionProvider.getSession(workspace, this.repositoryService.getRepository(repository));
            node = nodeIdentifier.contains("/") ? session.getRootNode().getNode(nodeIdentifier) : session.getNodeByUUID(nodeIdentifier);
            if (node == null) {
                return Response.Builder.withStatus((int)404).build();
            }
            Node dataNode = null;
            InputStream jcrData = null;
            if (node.isNodeType("nt:file")) {
                dataNode = node;
            } else if (node.isNodeType("nt:versionedChild")) {
                VersionHistory versionHistory = (VersionHistory)node.getProperty("jcr:childVersionHistory").getNode();
                String versionableUUID = versionHistory.getVersionableUUID();
                dataNode = session.getNodeByUUID(versionableUUID);
                System.out.println("===========>" + dataNode.getPath());
            } else {
                return Response.Builder.withStatus((int)404).build();
            }
            jcrData = dataNode.getNode("jcr:content").getProperty("jcr:data").getStream();
            return Response.Builder.ok().entity((Object)jcrData, "image").build();
        }
        catch (PathNotFoundException e) {
            return Response.Builder.withStatus((int)404).build();
        }
        catch (ItemNotFoundException e) {
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Response.Builder.serverError().build();
        }
    }

    @HTTPMethod(value="GET")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response serveImage(@URIParam(value="repositoryName") String repository, @URIParam(value="workspaceName") String workspace, @URIParam(value="nodeIdentifier") String nodeIdentifier, @QueryParam(value="propertyName") String propertyName) {
        Node node = null;
        try {
            SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
            Session session = sessionProvider.getSession(workspace, this.repositoryService.getRepository(repository));
            node = nodeIdentifier.contains("/") ? session.getRootNode().getNode(nodeIdentifier) : session.getNodeByUUID(nodeIdentifier);
            if (node == null) {
                return Response.Builder.withStatus((int)404).build();
            }
            InputStream jcrData = node.getProperty(propertyName).getStream();
            return Response.Builder.ok().entity((Object)jcrData, "image").build();
        }
        catch (PathNotFoundException e) {
            return Response.Builder.withStatus((int)404).build();
        }
        catch (ItemNotFoundException e) {
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Response.Builder.serverError().build();
        }
    }

    public String generateURI(Node file) throws Exception {
        if (!file.isNodeType("nt:file")) {
            throw new UnsupportedOperationException("The node isn't nt:file");
        }
        StringBuilder builder = new StringBuilder();
        String repository = ((ManageableRepository)file.getSession().getRepository()).getConfiguration().getName();
        String workspaceName = file.getSession().getWorkspace().getName();
        String nodeIdentifiler = null;
        InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
        if (stream.available() == 0) {
            return null;
        }
        stream.close();
        nodeIdentifiler = file.isNodeType("mix:referenceable") ? file.getUUID() : file.getPath().replaceFirst("/", "");
        String accessURI = this.baseRestURI;
        String userId = file.getSession().getUserID();
        if (!SystemIdentity.ANONIM.equals(userId) && SystemIdentity.SYSTEM.equalsIgnoreCase(userId)) {
            accessURI = this.baseRestURI.concat("private/");
        }
        return builder.append(accessURI).append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?type=file").toString();
    }

    public String generateURI(Node file, String propertyName) throws Exception {
        StringBuilder builder = new StringBuilder();
        String repository = ((ManageableRepository)file.getSession().getRepository()).getConfiguration().getName();
        String workspaceName = file.getSession().getWorkspace().getName();
        String nodeIdentifiler = null;
        nodeIdentifiler = file.isNodeType("mix:referenceable") ? file.getUUID() : file.getPath().replaceFirst("/", "");
        String accessURI = this.baseRestURI;
        String userId = file.getSession().getUserID();
        if (!SystemIdentity.ANONIM.equals(userId) && SystemIdentity.SYSTEM.equalsIgnoreCase(userId)) {
            accessURI = this.baseRestURI.concat("private/");
        }
        return builder.append(accessURI).append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?propertyName=").append(propertyName).toString();
    }
}

