/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.link.LinkBean;
import org.exoplatform.services.wcm.link.LiveLinkManagerService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveLinkManagerServiceImpl
implements LiveLinkManagerService {
    private ExoCache brokenLinksCache;
    private WCMConfigurationService configurationService;
    private RepositoryService repositoryService;
    private LivePortalManagerService livePortalManagerService;
    private String internalServerPath;
    private static Log log = ExoLogger.getLogger(LiveLinkManagerServiceImpl.class);

    public LiveLinkManagerServiceImpl(WCMConfigurationService configurationService, RepositoryService repositoryService, LivePortalManagerService livePortalManagerService, CacheService cacheService, InitParams initParams) throws Exception {
        this.configurationService = configurationService;
        this.repositoryService = repositoryService;
        this.livePortalManagerService = livePortalManagerService;
        this.brokenLinksCache = cacheService.getCacheInstance(this.getClass().getName());
        this.readServerConfig(initParams);
    }

    @Override
    public List<LinkBean> getActiveLinks(String portalName) throws Exception {
        return null;
    }

    private void readServerConfig(InitParams initParams) {
        try {
            PropertiesParam propertiesParam = initParams.getPropertiesParam("server.config");
            String scheme = propertiesParam.getProperty("scheme");
            String hostName = propertiesParam.getProperty("hostName");
            String port = propertiesParam.getProperty("port");
            StringBuilder builder = new StringBuilder();
            builder.append(scheme).append("://").append(hostName).append(":").append(port);
            this.internalServerPath = builder.toString();
            log.info((Object)("server path for internal link validation:" + this.internalServerPath));
        }
        catch (Exception e) {
            log.error((Object)"The internal server config: scheme, hostName, port need be configed as parameter");
        }
    }

    @Override
    public List<String> getActiveLinks(Node webContent) throws Exception {
        return null;
    }

    @Override
    public List<LinkBean> getBrokenLinks(String portalName) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node portal = this.livePortalManagerService.getLivePortal(portalName, sessionProvider);
        String path = portal.getPath();
        Session session = portal.getSession();
        ArrayList<LinkBean> listBrokenLinks = new ArrayList<LinkBean>();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from exo:webContent where jcr:path like '" + path + "/%'", "sql");
        QueryResult results = query.execute();
        NodeIterator iter = results.getNodes();
        while (iter.hasNext()) {
            Node webContent = iter.nextNode();
            List<String> listBrokenUrls = this.getBrokenLinks(webContent);
            for (String brokenUrl : listBrokenUrls) {
                LinkBean linkBean = new LinkBean(brokenUrl, "broken");
                listBrokenLinks.add(linkBean);
            }
        }
        sessionProvider.close();
        return listBrokenLinks;
    }

    @Override
    public List<String> getBrokenLinks(Node webContent) throws Exception {
        List listBrokenUrls = (List)this.brokenLinksCache.get((Serializable)((Object)webContent.getUUID()));
        if (listBrokenUrls == null) {
            for (Value value : webContent.getProperty("exo:links").getValues()) {
                String link = value.getString();
                LinkBean linkBean = LinkBean.parse(link);
                if (!linkBean.isBroken()) continue;
                listBrokenUrls.add(linkBean.getUrl());
            }
            this.brokenLinksCache.put((Serializable)((Object)webContent.getUUID()), (Object)listBrokenUrls);
        }
        return listBrokenUrls;
    }

    @Override
    public List<LinkBean> getUncheckedLinks(String portalName) throws Exception {
        return null;
    }

    @Override
    public List<String> getUncheckedLinks(Node webContent) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateLink() throws Exception {
        Collection<NodeLocation> nodeLocationCollection = this.configurationService.getAllLivePortalsLocation();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            for (NodeLocation nodeLocation : nodeLocationCollection) {
                String repository = nodeLocation.getRepository();
                String workspace = nodeLocation.getWorkspace();
                String path = nodeLocation.getPath();
                ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
                Session session = sessionProvider.getSession(workspace, manageableRepository);
                this.updateLinkStatus(session, "select * from exo:linkable where jcr:path like '" + path + "/%'");
            }
        }
        catch (Exception exception) {
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateLink(String portalName) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node portal = this.livePortalManagerService.getLivePortal(portalName, sessionProvider);
            String path = portal.getPath();
            Session session = portal.getSession();
            this.updateLinkStatus(session, "select * from exo:linkable where jcr:path like '" + path + "/%'");
        }
        catch (Exception exception) {
        }
        finally {
            sessionProvider.close();
        }
    }

    protected void updateLinkStatus(Session session, String queryCommand) throws Exception {
        ArrayList<String> listBrokenLinks = new ArrayList<String>();
        ValueFactory valueFactory = session.getValueFactory();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryCommand, "sql");
        QueryResult results = query.execute();
        NodeIterator iter = results.getNodes();
        while (iter.hasNext()) {
            Node webContent = iter.nextNode();
            if (!webContent.isCheckedOut() || webContent.isLocked() || webContent.isCheckedOut() && !webContent.getParent().isCheckedOut()) continue;
            Property links = webContent.getProperty("exo:links");
            Value[] oldValues = links.getValues();
            Value[] newValues = new Value[oldValues.length];
            for (int iValues = 0; iValues < oldValues.length; ++iValues) {
                String oldLink = oldValues[iValues].getString();
                if (oldLink.equals("")) continue;
                LinkBean linkBean = LinkBean.parse(oldLink);
                String oldUrl = linkBean.getUrl();
                String oldStatus = this.getLinkStatus(oldUrl);
                String updatedLink = new LinkBean(oldUrl, oldStatus).toString();
                log.info((Object)updatedLink);
                newValues[iValues] = valueFactory.createValue(updatedLink);
                if (!oldStatus.equals("broken")) continue;
                listBrokenLinks.add(oldUrl);
            }
            webContent.setProperty("exo:links", newValues);
            this.brokenLinksCache.put((Serializable)((Object)webContent.getUUID()), listBrokenLinks);
        }
        session.save();
    }

    protected String getLinkStatus(String strUrl) {
        block4: {
            try {
                GetMethod getMethod;
                HttpClient httpClient;
                String fullUrl = strUrl;
                if (strUrl.startsWith("/")) {
                    fullUrl = this.internalServerPath + strUrl;
                }
                if ((httpClient = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager())).executeMethod((HttpMethod)(getMethod = new GetMethod(fullUrl = fullUrl.replaceAll(" ", "%20")))) == 200) {
                    return "active";
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Exception when validate link:" + strUrl), (Throwable)e);
            }
        }
        return "broken";
    }
}

