/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.io.Reader;
import java.io.StringReader;
import org.exoplatform.portal.webui.skin.Resource;
import org.exoplatform.portal.webui.skin.ResourceResolver;
import org.exoplatform.portal.webui.skin.SkinConfig;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.services.wcm.skin.XSkinService;

public class WCMSkinResourceResolver
implements ResourceResolver {
    private SkinService skinService;

    public WCMSkinResourceResolver(SkinService skinService) {
        this.skinService = skinService;
    }

    public Resource resolve(String path) {
        String cssData;
        if (!path.matches(XSkinService.SKIN_PATH_REGEXP)) {
            return null;
        }
        String[] elements = path.split("/");
        String portalName = elements[4];
        String skinName = elements[5];
        String skinModule = portalName;
        String cssPath = null;
        SkinConfig portalSkinConfig = this.skinService.getSkin(portalName, skinName);
        if (portalSkinConfig != null) {
            cssPath = portalSkinConfig.getCSSPath();
        }
        if (cssPath == null) {
            for (SkinConfig skinConfig : this.skinService.getPortalSkins(skinName)) {
                if (!skinConfig.getModule().equals(skinModule)) continue;
                cssPath = skinConfig.getCSSPath();
                break;
            }
        }
        if ((cssData = this.skinService.getMergedCSS(cssPath)) == null) {
            return null;
        }
        return new Resource(path){

            public Reader read() {
                return new StringReader(cssData);
            }
        };
    }
}

