/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.services.html.HTMLDocument;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.wcm.link.HyperLinkUtilExtended;
import org.exoplatform.services.wcm.link.LinkBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkExtractor {
    public List<String> extractLink(HTMLDocument htmlDocument) throws Exception {
        ArrayList<String> listHyperlink = new ArrayList<String>();
        HTMLNode htmlRootNode = htmlDocument.getRoot();
        HyperLinkUtilExtended linkUtil = new HyperLinkUtilExtended();
        for (String link : linkUtil.getSiteLink(htmlRootNode)) {
            if (listHyperlink.contains(link)) continue;
            listHyperlink.add(link);
        }
        for (String image : linkUtil.getImageLink(htmlRootNode)) {
            if (listHyperlink.contains(image)) continue;
            listHyperlink.add(image);
        }
        return listHyperlink;
    }

    public void updateLinks(Node webContent, List<String> newLinks) throws Exception {
        ValueFactory valueFactory = webContent.getSession().getValueFactory();
        if (webContent.canAddMixin("exo:linkable")) {
            webContent.addMixin("exo:linkable");
        }
        ArrayList<String> listExtractedLink = new ArrayList<String>();
        if (webContent.hasProperty("exo:links")) {
            Property property = webContent.getProperty("exo:links");
            for (Value value : property.getValues()) {
                listExtractedLink.add(value.getString());
            }
        }
        ArrayList<String> listResult = new ArrayList<String>();
        for (String extractedLink : listExtractedLink) {
            for (String newUrl : newLinks) {
                if (!LinkBean.parse(extractedLink).getUrl().equals(newUrl)) continue;
                listResult.add(extractedLink);
            }
        }
        ArrayList<String> listTemp = new ArrayList<String>();
        listTemp.addAll(newLinks);
        for (String newUrl : newLinks) {
            for (String extractedLink : listExtractedLink) {
                if (!newUrl.equals(LinkBean.parse(extractedLink).getUrl())) continue;
                listTemp.set(newLinks.indexOf(newUrl), "");
            }
        }
        for (String strTemp : listTemp) {
            if (strTemp.equals("")) continue;
            listResult.add(strTemp);
        }
        Value[] values = new Value[listResult.size()];
        for (String url : listResult) {
            if (url.indexOf("status=") < 0) {
                LinkBean linkBean = new LinkBean(url, "unchecked");
                values[listResult.indexOf((Object)url)] = valueFactory.createValue(linkBean.toString());
                continue;
            }
            values[listResult.indexOf((Object)url)] = valueFactory.createValue(url);
        }
        webContent.setProperty("exo:links", values);
    }
}

