/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.NodeLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMConfigurationService {
    private static Log log = ExoLogger.getLogger((String)"wcm:WCMConfiguarationService");
    private HashMap<String, NodeLocation> livePortalsLocations = new HashMap();
    private HashMap<String, String> sharedPortals = new HashMap();
    private String parameterizedPageURI;
    private String redactorMembershipType;
    private String publishingPortletName;
    private ExoProperties runtimeContextParams;
    private DriveData siteDriveConfig;
    public static final String SITE_PATH_EXP = "\\{sitePath\\}";
    public static final String SITE_NAME_EXP = "\\{siteName\\}";

    public WCMConfigurationService(InitParams initParams) throws Exception {
        this.parameterizedPageURI = initParams.getValueParam("parameterizedPageURI").getValue();
        this.redactorMembershipType = initParams.getValueParam("redactorMembershipType").getValue();
        log.info((Object)("Page URI is used for view DMS Document as a web page: " + this.parameterizedPageURI));
        this.publishingPortletName = initParams.getValueParam("publishingPortletName").getValue();
        log.info((Object)("The portlet is used to publish content in a web page: " + this.publishingPortletName));
        Iterator iterator = initParams.getPropertiesParamIterator();
        while (iterator.hasNext()) {
            PropertiesParam param = (PropertiesParam)iterator.next();
            if ("share.portal.config".endsWith(param.getName())) {
                String repository = param.getProperty("repository");
                String portalName = param.getProperty("portalName");
                this.sharedPortals.put(repository, portalName);
                log.info((Object)("Name of shared portal to share resources for all portals in repository: " + repository + " is: " + portalName));
                continue;
            }
            if (!"RuntimeContextParams".equalsIgnoreCase(param.getName())) continue;
            this.runtimeContextParams = param.getProperties();
        }
        Iterator locations = initParams.getObjectParamIterator();
        while (locations.hasNext()) {
            ObjectParameter objectParameter = (ObjectParameter)locations.next();
            if ("live.portals.location.config".equals(objectParameter.getName())) {
                NodeLocation objectParam = (NodeLocation)objectParameter.getObject();
                this.livePortalsLocations.put(objectParam.getRepository(), objectParam);
                log.info((Object)("Location that resources for all live portal is stored in repository:" + objectParam.getRepository() + " is in workspace: " + objectParam.getWorkspace() + " and with path: " + objectParam.getPath()));
            }
            if (!"site.drive.config".equals(objectParameter.getName())) continue;
            this.siteDriveConfig = (DriveData)objectParameter.getObject();
        }
    }

    public String getRedactorMembershipType() {
        return this.redactorMembershipType;
    }

    public String getParameterizedPageURI() {
        return this.parameterizedPageURI;
    }

    public String getPublishingPortletName() {
        return this.publishingPortletName;
    }

    public DriveData getSiteDriveConfig() {
        return this.siteDriveConfig;
    }

    public NodeLocation getLivePortalsLocation(String repository) {
        return this.livePortalsLocations.get(repository);
    }

    public String getRuntimeContextParam(String paramName) {
        if (this.runtimeContextParams != null) {
            return (String)this.runtimeContextParams.get((Object)paramName);
        }
        return null;
    }

    public Collection<String> getRuntimeContextParams() {
        if (this.runtimeContextParams != null) {
            return this.runtimeContextParams.values();
        }
        return null;
    }

    public String getSharedPortalName(String repository) {
        return this.sharedPortals.get(repository);
    }

    public Collection<NodeLocation> getAllLivePortalsLocation() {
        return this.livePortalsLocations.values();
    }
}

