/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import javax.jcr.Node;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WebSchemaHandler;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWebSchemaHandler
extends BaseComponentPlugin
implements WebSchemaHandler {
    protected final String EXO_OWNABLE = "exo:owneable".intern();
    protected final String NT_FOLDER = "nt:folder".intern();
    protected final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    protected final String NT_FILE = "nt:file".intern();

    @Override
    public boolean matchHandler(Node node, SessionProvider sessionProvider) throws Exception {
        String handlerNodeType = this.getHandlerNodeType();
        String parentNodeType = this.getParentNodeType();
        if (!node.getPrimaryNodeType().getName().equals(handlerNodeType)) {
            return false;
        }
        return node.getParent().isNodeType(parentNodeType);
    }

    @Override
    public void onCreateNode(Node node, SessionProvider sessionProvider) throws Exception {
    }

    @Override
    public void onModifyNode(Node node, SessionProvider sessionProvider) throws Exception {
    }

    @Override
    public void onRemoveNode(Node node, SessionProvider sessionProvider) throws Exception {
    }

    protected abstract String getHandlerNodeType();

    protected abstract String getParentNodeType();

    protected void addMixin(Node node, String mixin) throws Exception {
        if (!node.isNodeType(mixin)) {
            node.addMixin(mixin);
        }
    }

    protected <T> T getService(Class<T> clazz) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    protected Node findPortalNode(Node child, SessionProvider sessionProvider) throws Exception {
        LivePortalManagerService livePortalManagerService = this.getService(LivePortalManagerService.class);
        String portalName = null;
        for (String portalPath : livePortalManagerService.getLivePortalsPath()) {
            if (!child.getPath().startsWith(portalPath)) continue;
            portalName = livePortalManagerService.getPortalNameByPath(portalPath);
            break;
        }
        if (portalName == null) {
            return null;
        }
        return livePortalManagerService.getLivePortal(portalName, sessionProvider);
    }

    protected String getFileMimeType(Node file) throws Exception {
        String mimeType = null;
        try {
            mimeType = file.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (Exception e) {
            MimeTypeResolver resolver = new MimeTypeResolver();
            resolver.setDefaultMimeType("text/plain");
            mimeType = resolver.getMimeType(file.getName());
        }
        return mimeType;
    }
}

