/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.listener;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.jcr.DataStorageImpl;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.PortalArtifactsInitializerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLivePortalEventListener
extends Listener<DataStorageImpl, PortalConfig> {
    private static Log log = ExoLogger.getLogger(CreateLivePortalEventListener.class);

    public final void onEvent(Event<DataStorageImpl, PortalConfig> event) throws Exception {
        PortalConfig portalConfig = (PortalConfig)event.getData();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)container.getComponentInstanceOfType(LivePortalManagerService.class);
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            livePortalManagerService.addLivePortal(portalConfig, sessionProvider);
            log.info((Object)("Create new resource storage for portal: " + portalConfig.getName()));
        }
        catch (Exception e) {
            log.error((Object)("Error when create new resource storage: " + portalConfig.getName()), (Throwable)e);
        }
        ManageDriveService manageDriveService = (ManageDriveService)container.getComponentInstanceOfType(ManageDriveService.class);
        WCMConfigurationService configurationService = (WCMConfigurationService)container.getComponentInstanceOfType(WCMConfigurationService.class);
        try {
            Node portal = livePortalManagerService.getLivePortal(portalConfig.getName(), sessionProvider);
            this.createPortalDrive(portal, portalConfig, configurationService, manageDriveService);
        }
        catch (Exception e) {
            log.error((Object)("Error when create drive for portal: " + portalConfig.getName()), (Throwable)e);
        }
        PortalArtifactsInitializerService artifactsInitializerService = (PortalArtifactsInitializerService)container.getComponentInstanceOfType(PortalArtifactsInitializerService.class);
        try {
            artifactsInitializerService.deployArtifactsToPortal(portalConfig.getName(), sessionProvider);
        }
        catch (Exception e) {
            log.error((Object)("Error when create drive for portal: " + portalConfig.getName()), (Throwable)e);
        }
        sessionProvider.close();
    }

    private void createPortalDrive(Node portal, PortalConfig portalConfig, WCMConfigurationService wcmConfigService, ManageDriveService driveService) throws Exception {
        Session session = portal.getSession();
        String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        String workspace = session.getWorkspace().getName();
        DriveData mainDriveData = wcmConfigService.getSiteDriveConfig();
        String drive = portal.getName().substring(0, 1).toUpperCase() + portal.getName().substring(1);
        String permission = portalConfig.getEditPermission();
        String portalPath = portal.getPath();
        String homePath = mainDriveData.getHomePath();
        homePath = homePath.replaceAll("\\{siteName\\}", drive);
        homePath = homePath.replaceAll("\\{sitePath\\}", portalPath);
        String views = mainDriveData.getViews();
        String icon = mainDriveData.getIcon();
        boolean viewReferences = mainDriveData.getViewPreferences();
        boolean viewNonDocument = mainDriveData.getViewNonDocument();
        boolean viewSideBar = mainDriveData.getViewSideBar();
        boolean showHiddenNode = mainDriveData.getShowHiddenNode();
        String allowCreateFolder = mainDriveData.getAllowCreateFolder();
        driveService.addDrive(drive, workspace, permission, homePath, views, icon, viewReferences, viewNonDocument, viewSideBar, showHiddenNode, repository, allowCreateFolder);
        log.info((Object)("Create new drive for portal: " + portalConfig.getName()));
    }
}

