/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.viewer;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterPublicUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.viewer.UINewsletterViewerEmailAddressValidator;
import org.exoplatform.wcm.webui.newsletter.viewer.UINewsletterViewerForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/newsletter/NewsletterViewer/UINewsletterListViewer.gtmpl", events={@EventConfig(listeners={SubcribeActionListener.class}), @EventConfig(listeners={ForgetEmailActionListener.class}), @EventConfig(listeners={ChangeSubcriptionsActionListener.class})})
public class UINewsletterViewerForm
extends UIForm {
    public String userCode;
    public UIFormStringInput inputEmail;
    public String userMail = "";
    public boolean isUpdated = false;
    public NewsletterSubscriptionHandler subcriptionHandler;
    public NewsletterPublicUserHandler publicUserHandler;
    private UIFormCheckBoxInput<Boolean> checkBoxInput;
    private NewsletterCategoryHandler categoryHandler;
    private NewsletterManageUserHandler managerUserHandler;
    private NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
    private String linkToSendMail;
    private List<String> listIds;

    public UINewsletterViewerForm() throws Exception {
        this.categoryHandler = this.newsletterManagerService.getCategoryHandler();
        this.subcriptionHandler = this.newsletterManagerService.getSubscriptionHandler();
        this.publicUserHandler = this.newsletterManagerService.getPublicUserHandler();
        this.managerUserHandler = this.newsletterManagerService.getManageUserHandler();
        this.setActions(new String[]{"Subcribe"});
        this.inputEmail = new UIFormStringInput("inputEmail", "Email", null);
        this.inputEmail.addValidator(MandatoryValidator.class, new Object[0]).addValidator(UINewsletterViewerEmailAddressValidator.class, new Object[0]);
        this.addChild((UIComponent)this.inputEmail);
    }

    public void setListIds(List<String> listIds) {
        this.listIds = listIds;
    }

    public void init(List<NewsletterSubscriptionConfig> listNewsletterSubcription, String categoryName) throws Exception {
        if (this.userCode != null && this.userCode.trim().length() > 0) {
            for (NewsletterSubscriptionConfig newsletterSubcription : listNewsletterSubcription) {
                String subcriptionPattern = categoryName + "#" + newsletterSubcription.getName();
                if (this.getChildById(subcriptionPattern) != null) {
                    this.removeChildById(subcriptionPattern);
                }
                this.checkBoxInput = new UIFormCheckBoxInput(subcriptionPattern, subcriptionPattern, (Object)false);
                if (this.listIds.contains(subcriptionPattern)) {
                    this.checkBoxInput.setChecked(true);
                } else {
                    this.checkBoxInput.setChecked(false);
                }
                this.addChild((UIComponent)this.checkBoxInput);
            }
        } else {
            for (NewsletterSubscriptionConfig newsletterSubcription : listNewsletterSubcription) {
                String subcriptionPattern = categoryName + "#" + newsletterSubcription.getName();
                if (this.getChildById(subcriptionPattern) != null) continue;
                this.checkBoxInput = new UIFormCheckBoxInput(subcriptionPattern, subcriptionPattern, (Object)false);
                this.addChild((UIComponent)this.checkBoxInput);
            }
        }
    }

    public void setInforConfirm(String userEmail, String userCode) {
        this.userMail = userEmail;
        this.userCode = userCode;
    }

    private void setActionAgain() {
        this.setActions(new String[]{"ForgetEmail", "ChangeSubcriptions"});
        this.isUpdated = true;
    }

    private List<String> listSubscriptionChecked() {
        ArrayList<String> listSubscription = new ArrayList<String>();
        for (UIComponent component : this.getChildren()) {
            try {
                if (!((UIFormCheckBoxInput)component).isChecked()) continue;
                listSubscription.add(component.getName());
            }
            catch (ClassCastException ex) {}
        }
        return listSubscription;
    }

    private List<NewsletterCategoryConfig> getListCategories() {
        try {
            return this.categoryHandler.getListCategories(NewsLetterUtil.getPortalName(), Utils.getSessionProvider((UIContainer)this));
        }
        catch (Exception e) {
            return new ArrayList<NewsletterCategoryConfig>();
        }
    }

    private List<NewsletterSubscriptionConfig> getListSubscription(String categoryName) {
        try {
            List listSubscription = this.subcriptionHandler.getSubscriptionsByCategory(NewsLetterUtil.getPortalName(), categoryName, Utils.getSessionProvider((UIContainer)this));
            this.init(listSubscription, categoryName);
            return listSubscription;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<NewsletterSubscriptionConfig>();
        }
    }

    private void setLink(String url) {
        this.linkToSendMail = NewsLetterUtil.generateLink((String)url);
    }

    static /* synthetic */ List access$000(UINewsletterViewerForm x0) {
        return x0.listSubscriptionChecked();
    }

    static /* synthetic */ NewsletterManageUserHandler access$100(UINewsletterViewerForm x0) {
        return x0.managerUserHandler;
    }

    static /* synthetic */ String access$200(UINewsletterViewerForm x0) {
        return x0.linkToSendMail;
    }
}

