/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterTemplateHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryContainer;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryDialogSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/newsletter/NewsletterManager/UINewsletterEntryDialogSelector.gtmpl", events={@EventConfig(listeners={UpdateNewsletterActionListener.class}), @EventConfig(listeners={OpenWebcontentSelectorFormActionListener.class}), @EventConfig(listeners={ChangeTemplateActionListener.class}), @EventConfig(listeners={ChangeCategoryActionListener.class})})
public class UINewsletterEntryDialogSelector
extends UIForm {
    public static final String NEWSLETTER_ENTRY_TEMPLATE = "UINewsletterEntryTemplate";
    public static final String NEWSLETTER_ENTRY_SEND_DATE = "UINewsletterEntrySendDate";
    private String dialog = "dialog1";

    public String getDialog() {
        return this.dialog;
    }

    public void setDialog(String dialog) {
        this.dialog = dialog;
    }

    public UINewsletterEntryDialogSelector() throws Exception {
        this.setActions(new String[]{"UpdateNewsletter"});
        UIFormSelectBox newsletterEntryTemplate = new UIFormSelectBox(NEWSLETTER_ENTRY_TEMPLATE, NEWSLETTER_ENTRY_TEMPLATE, new ArrayList());
        newsletterEntryTemplate.setOnChange("ChangeTemplate");
        this.addChild((UIComponent)newsletterEntryTemplate);
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(NEWSLETTER_ENTRY_SEND_DATE, NEWSLETTER_ENTRY_SEND_DATE, null, true));
    }

    public void init(String CategoryName, String subScriptionName) throws Exception {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        NewsletterCategoryHandler newsletterCategoryHandler = newsletterManagerService.getCategoryHandler();
        SessionProvider sessionProvider = Utils.getSessionProvider((UIContainer)this);
        String portalName = Util.getUIPortal().getName();
        List newsletterCategoryConfigs = newsletterCategoryHandler.getListCategories(portalName, sessionProvider);
        ArrayList<SelectItemOption> categories = new ArrayList<SelectItemOption>();
        for (NewsletterCategoryConfig newsletterCategoryConfig : newsletterCategoryConfigs) {
            categories.add(new SelectItemOption(newsletterCategoryConfig.getTitle(), (Object)newsletterCategoryConfig.getName()));
        }
        UIFormSelectBox categorySelectBox = new UIFormSelectBox("UINewsletterEntryCategorySelectBox", "UINewsletterEntryCategorySelectBox", categories);
        categorySelectBox.setOnChange("ChangeCategory");
        if (CategoryName != null && CategoryName.trim().length() > 0) {
            categorySelectBox.setValue(CategoryName);
            categorySelectBox.setDisabled(true);
        }
        if (CategoryName == null) {
            CategoryName = (String)((SelectItemOption)categories.get(0)).getValue();
        }
        NewsletterSubscriptionHandler newsletterSubscriptionHandler = newsletterManagerService.getSubscriptionHandler();
        List listSubscriptions = newsletterSubscriptionHandler.getSubscriptionsByCategory(portalName, CategoryName, sessionProvider);
        ArrayList<SelectItemOption> subscriptions = new ArrayList<SelectItemOption>();
        for (NewsletterSubscriptionConfig newsletterSubscriptionConfig : listSubscriptions) {
            subscriptions.add(new SelectItemOption(newsletterSubscriptionConfig.getTitle(), (Object)newsletterSubscriptionConfig.getName()));
        }
        UIFormSelectBox subscriptionSelectBox = new UIFormSelectBox("UINewsletterEntrySubscriptionSelectBox", "UINewsletterEntrySubscriptionSelectBox", subscriptions);
        if (subScriptionName != null && subScriptionName.trim().length() > 0) {
            subscriptionSelectBox.setValue(subScriptionName);
            subscriptionSelectBox.setDisabled(true);
        }
        this.addChild((UIComponent)categorySelectBox);
        this.addChild((UIComponent)subscriptionSelectBox);
        NewsletterCategoryConfig categoryConfig = ((UINewsletterEntryContainer)this.getAncestorOfType(UINewsletterEntryContainer.class)).getCategoryConfig();
        if (categoryConfig == null) {
            categoryConfig = (NewsletterCategoryConfig)newsletterCategoryConfigs.get(0);
        }
        this.updateTemplateSelectBox(categoryConfig);
    }

    public void updateTemplateSelectBox(NewsletterCategoryConfig categoryConfig) throws Exception {
        ArrayList<SelectItemOption> templates = new ArrayList<SelectItemOption>();
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        NewsletterTemplateHandler newsletterTemplateHandler = newsletterManagerService.getTemplateHandler();
        List templateNodes = newsletterTemplateHandler.getTemplates(Util.getUIPortal().getName(), categoryConfig);
        for (Node template : templateNodes) {
            templates.add(new SelectItemOption(template.getProperty("exo:title").getString(), (Object)template.getName()));
        }
        this.getUIFormSelectBox(NEWSLETTER_ENTRY_TEMPLATE).setOptions(templates);
    }
}

