/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.category;

import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequestWrapper;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.wcm.webui.category.UICategoryNavigationUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;

@ComponentConfig(events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})})
public class UICategoryNavigationTreeBase
extends UITree {
    public String renderNode(Object obj) throws Exception {
        String beanIconField;
        Node node = (Node)obj;
        String nodeTypeIcon = Utils.getNodeTypeIcon((Node)node, (String)"16x16Icon");
        String nodeIcon = this.getExpandIcon();
        String iconGroup = this.getIcon();
        String note = "";
        if (this.isSelected(obj)) {
            nodeIcon = this.getColapseIcon();
            iconGroup = this.getSelectedIcon();
            note = " NodeSelected";
        }
        if ((beanIconField = this.getBeanIconField()) != null && beanIconField.length() > 0 && this.getFieldValue(obj, beanIconField) != null) {
            iconGroup = (String)this.getFieldValue(obj, beanIconField);
        }
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        String requestURI = requestWrapper.getRequestURI();
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        String categoryPath = String.valueOf(this.getId(obj));
        String shortPath = "";
        shortPath = requestURI.indexOf(preferenceTreeName) < 0 ? categoryPath.substring(categoryPath.indexOf(preferenceTreeName) - 1) : categoryPath.substring(categoryPath.lastIndexOf("/"));
        String objId = requestURI + shortPath;
        StringBuilder builder = new StringBuilder();
        if (nodeIcon.equals(this.getExpandIcon())) {
            builder.append(" <a class=\"").append(nodeIcon).append(" ").append(nodeTypeIcon).append("\" href=\"").append(objId).append("\">");
        } else {
            builder.append(" <a class=\"").append(nodeIcon).append(" ").append(nodeTypeIcon).append("\" onclick=\"eXo.portal.UIPortalControl.collapseTree(this)").append("\">");
        }
        UIRightClickPopupMenu popupMenu = this.getUiPopupMenu();
        String beanLabelField = this.getBeanLabelField();
        String className = "NodeIcon";
        boolean flgSymlink = false;
        if (Utils.isSymLink((Node)node)) {
            flgSymlink = true;
            className = "NodeIconLink";
        }
        if (popupMenu == null) {
            builder.append(" <div class=\"").append(className).append(" ").append(iconGroup).append(" ").append(nodeTypeIcon).append(note).append("\"").append(" title=\"").append(this.getFieldValue(obj, beanLabelField)).append("\"").append(">");
            if (flgSymlink) {
                builder.append("  <div class=\"LinkSmall\">").append(this.getFieldValue(obj, beanLabelField)).append("</div>");
            } else {
                builder.append(this.getFieldValue(obj, beanLabelField));
            }
            builder.append("</div>");
        } else {
            builder.append(" <div class=\"").append(className).append(" ").append(iconGroup).append(" ").append(nodeTypeIcon).append(note).append("\" ").append(popupMenu.getJSOnclickShowPopup(objId, null)).append(" title=\"").append(this.getFieldValue(obj, beanLabelField)).append("\"").append(">");
            if (flgSymlink) {
                builder.append("  <div class=\"LinkSmall\">").append(this.getFieldValue(obj, beanLabelField)).append("</div>");
            } else {
                builder.append(this.getFieldValue(obj, beanLabelField));
            }
            builder.append("</div>");
        }
        builder.append(" </a>");
        return builder.toString();
    }

    public String getTemplate() {
        return UICategoryNavigationUtils.getPortletPreferences().getValue("templatePath", null);
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        String repository = UICategoryNavigationUtils.getPortletPreferences().getValue("repository", null);
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig(repository).getSystemWorkspace();
        return new JCRResourceResolver(repository, workspace, TemplateService.EXO_TEMPLATE_FILE_PROP);
    }

    public String getActionLink() throws Exception {
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        String requestURI = requestWrapper.getRequestURI();
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        String preferenceTargetPage = portletPreferences.getValue("targetPath", "");
        String backPath = requestURI.substring(0, requestURI.lastIndexOf("/"));
        if (backPath.endsWith(preferenceTargetPage) || backPath.endsWith(Util.getUIPortal().getName())) {
            backPath = "javascript:void(0)";
        } else if (backPath.endsWith(preferenceTreeName)) {
            backPath = backPath.substring(0, backPath.lastIndexOf("/"));
        }
        return backPath;
    }

    public boolean isSelected(Object obj) throws Exception {
        Node selectedNode = (Node)this.getSelected();
        Node node = (Node)obj;
        if (selectedNode == null) {
            return false;
        }
        return selectedNode.getPath().equals(node.getPath());
    }
}

