/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UIContentListPresentation;
import org.exoplatform.wcm.webui.clv.UIListViewerBase;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UIContentListViewer.gtmpl", events={@EventConfig(listeners={UIListViewerBase.QuickEditActionListener.class})})
public class UIFolderViewer
extends UIListViewerBase {
    public void init() throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreference();
        NodeIterator nodeIterator = null;
        this.setViewAbleContent(true);
        this.messageKey = null;
        try {
            nodeIterator = this.getRenderedContentNodes();
        }
        catch (ItemNotFoundException e) {
            this.messageKey = "UIMessageBoard.msg.folder-not-found";
            this.setViewAbleContent(false);
            return;
        }
        catch (AccessDeniedException e) {
            this.messageKey = "UIMessageBoard.msg.no-permission";
            this.setViewAbleContent(false);
            return;
        }
        catch (Exception e) {
            this.messageKey = "UIMessageBoard.msg.error-nodetype";
            this.setViewAbleContent(false);
            return;
        }
        if (nodeIterator.getSize() == 0L) {
            this.messageKey = "UIMessageBoard.msg.folder-empty";
            this.setViewAbleContent(false);
            return;
        }
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        PaginatedNodeIterator paginatedNodeIterator = new PaginatedNodeIterator(nodeIterator, itemsPerPage);
        this.getChildren().clear();
        UIContentListPresentation contentListPresentation = (UIContentListPresentation)this.addChild(UIContentListPresentation.class, null, null);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        contentListPresentation.init(templatePath, resourceResolver, (PageList)paginatedNodeIterator);
        contentListPresentation.setContentColumn(portletPreferences.getValue("header", null));
        contentListPresentation.setShowLink(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        contentListPresentation.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        contentListPresentation.setShowReadmore(Boolean.parseBoolean(portletPreferences.getValue("showReadmore", null)));
        contentListPresentation.setHeader(portletPreferences.getValue("header", null));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public NodeIterator getRenderedContentNodes() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String repository = preferences.getValue("repository", null);
        String worksapce = preferences.getValue("workspace", null);
        String folderPath = preferences.getValue("folderPath", null);
        if (repository == null || worksapce == null || folderPath == null) {
            throw new ItemNotFoundException();
        }
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        ThreadLocalSessionProviderService providerService = (ThreadLocalSessionProviderService)this.getApplicationComponent(ThreadLocalSessionProviderService.class);
        SessionProvider sessionProvider = providerService.getSessionProvider(null);
        Session session = sessionProvider.getSession(worksapce, manageableRepository);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List listDocumentTypes = templateService.getDocumentTemplates(repository);
        StringBuffer documentTypeClause = new StringBuffer();
        for (int i = 0; i < listDocumentTypes.size(); ++i) {
            String documentType = (String)listDocumentTypes.get(i);
            documentTypeClause.append("jcr:primaryType = '" + documentType + "'");
            if (i == listDocumentTypes.size() - 1) continue;
            documentTypeClause.append(" OR ");
        }
        QueryManager manager = session.getWorkspace().getQueryManager();
        String orderQuery = " ORDER BY ";
        String orderBy = preferences.getValue("orderBy", null);
        String orderType = preferences.getValue("orderType", null);
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "exo:title";
        }
        orderQuery = orderQuery + orderBy + " " + orderType;
        String statement = "select * from nt:base where jcr:path like '" + folderPath + "/%' AND NOT jcr:path like'" + folderPath + "/%/%'" + " AND( " + documentTypeClause.toString() + ")" + orderQuery;
        if (Utils.isLiveMode()) {
            statement = "select * from nt:base where jcr:path like '" + folderPath + "/%' AND NOT jcr:path like'" + folderPath + "/%/%'" + " AND( " + documentTypeClause.toString() + ") AND publication:liveRevision IS NOT NULL AND publication:liveRevision <> '' " + orderQuery;
        }
        Query query = manager.createQuery(statement, "sql");
        return query.execute().getNodes();
    }
}

