/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv.config;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.tree.UINodeTree;
import org.exoplatform.ecm.webui.tree.UINodeTreeBuilder;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={UINodeTreeBuilder.ChangeNodeActionListener.class})})
public class UIContentsSelectionTreeBuilder
extends UINodeTreeBuilder {
    private Node currentPortal;
    private Node sharedPortal;

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer writer = context.getWriter();
        String folderExplorerTitle = context.getApplicationResourceBundle().getString("UIFolderExplorer.title");
        writer.write("<div class=\"FolderExplorer\">");
        writer.write("<div class=\"TitleBox\">" + folderExplorerTitle + "</div>");
        writer.write("<div class=\"FolderExplorerTree\">");
        this.buildTree();
        super.renderChildren();
        writer.write("</div>");
        writer.write("</div>");
    }

    public Node getCurrentPortal() {
        return this.currentPortal;
    }

    public void setCurrentPortal(Node currentPortal) {
        this.currentPortal = currentPortal;
    }

    public Node getSharedPortal() {
        return this.sharedPortal;
    }

    public void setSharedPortal(Node sharedPortal) {
        this.sharedPortal = sharedPortal;
    }

    public void buildTree() throws Exception {
        UINodeTree tree = (UINodeTree)this.getChild(UINodeTree.class);
        tree.setSelected((Object)this.currentNode);
        String currentPath = this.currentNode.getPath();
        String currentPortalPath = this.currentPortal.getPath();
        String sharedPortalPath = this.sharedPortal.getPath();
        Node webContentsFolder = null;
        Node documentsFolder = null;
        if (this.currentNode.getPath().equals(this.rootTreeNode.getPath())) {
            ArrayList<Node> portals = new ArrayList<Node>();
            portals.add(this.currentPortal);
            portals.add(this.sharedPortal);
            tree.setSibbling(portals);
            tree.setParentSelected((Object)this.rootTreeNode);
        } else if (currentPath.equals(sharedPortalPath)) {
            webContentsFolder = this.getWebContentsFolder(this.sharedPortal);
            documentsFolder = this.getDocumentsFolder(this.sharedPortal);
            ArrayList<Node> children = new ArrayList<Node>();
            children.add(webContentsFolder);
            children.add(documentsFolder);
            tree.setChildren(children);
            tree.setSibbling(children);
            tree.setParentSelected((Object)this.rootTreeNode);
        } else if (currentPath.equals(currentPortalPath)) {
            webContentsFolder = this.getWebContentsFolder(this.currentPortal);
            documentsFolder = this.getDocumentsFolder(this.currentPortal);
            ArrayList<Node> children = new ArrayList<Node>();
            children.add(webContentsFolder);
            children.add(documentsFolder);
            tree.setChildren(children);
            tree.setSibbling(children);
            tree.setParentSelected((Object)this.rootTreeNode);
        } else {
            List children = this.filterSubFolder(this.currentNode);
            tree.setChildren(children);
            tree.setSibbling(children);
            tree.setParentSelected((Object)this.currentNode.getParent());
        }
    }

    private List<Node> filterSubFolder(Node parent) throws Exception {
        ArrayList<Node> subFolderList = new ArrayList<Node>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repository = repositoryService.getCurrentRepository().getConfiguration().getName();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List listDocumentTypes = templateService.getDocumentTemplates(repository);
        NodeIterator iterator = parent.getNodes();
        while (iterator.hasNext()) {
            Node child = iterator.nextNode();
            NodeType nodeType = child.getPrimaryNodeType();
            if (!nodeType.isNodeType("nt:folder") && !nodeType.isNodeType("nt:unstructured") || listDocumentTypes.contains(nodeType.getName())) continue;
            subFolderList.add(child);
        }
        return subFolderList;
    }

    public Node getWebContentsFolder(Node portal) throws Exception {
        WebSchemaConfigService configService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
        PortalFolderSchemaHandler portalFolderSchemaHandler = (PortalFolderSchemaHandler)configService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
        return portalFolderSchemaHandler.getWebContentStorage(portal);
    }

    public Node getDocumentsFolder(Node portal) throws Exception {
        WebSchemaConfigService configService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
        PortalFolderSchemaHandler portalFolderSchemaHandler = (PortalFolderSchemaHandler)configService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
        return portalFolderSchemaHandler.getDocumentStorage(portal);
    }
}

