/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.HashMap;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationState;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pcv.UIContentViewer;
import org.exoplatform.wcm.webui.pcv.UIContentViewerContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ParameterizedContentViewer/UIContentViewerContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIContentViewerContainer
extends UIContainer {
    private boolean isDraftRevision = false;
    private boolean isObsoletedContent = false;
    private UIContentViewer uiContentViewer;
    private boolean isPrint;

    public UIContentViewerContainer() throws Exception {
        this.addChild(UIContentViewer.class, null, null);
        this.uiContentViewer = (UIContentViewer)this.getChild(UIContentViewer.class);
    }

    /*
     * Unable to fully structure code
     */
    public void processRender(WebuiRequestContext context) throws Exception {
        porletRequestContext = (PortletRequestContext)context;
        requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        portalRequestContext = Util.getPortalRequestContext();
        uiPortal = Util.getUIPortal();
        portalURI = portalRequestContext.getPortalURI();
        requestURI = requestWrapper.getRequestURI();
        pageNodeSelected = uiPortal.getSelectedNode().getName();
        parameters = null;
        object = requestWrapper.getAttribute("ParameterizedContentViewerPortlet.data.object");
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)requestURI, (String)portalURI.concat(pageNodeSelected + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (!parameters.matches("(.*)/(.*)")) {
            this.renderErrorMessage(context, "UIMessageBoard.msg.content-not-found");
            return;
        }
        nodeIdentifier = null;
        params = parameters.split("/");
        repository = params[0];
        workspace = params[1];
        currentNode = null;
        providerService = (ThreadLocalSessionProviderService)this.getApplicationComponent(ThreadLocalSessionProviderService.class);
        sessionProvider = providerService.getSessionProvider(null);
        session = null;
        if (object instanceof ItemNotFoundException || object instanceof AccessControlException || object instanceof ItemNotFoundException || object == null) {
            repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            try {
                manageableRepository = repositoryService.getRepository(repository);
                session = sessionProvider.getSession(workspace, manageableRepository);
                if (params.length > 2) {
                    identifier = new StringBuffer();
                    for (i = 2; i < params.length; ++i) {
                        identifier.append("/").append(params[i]);
                    }
                    nodeIdentifier = identifier.toString();
                    isUUID = false;
                    try {
                        currentNode = (Node)session.getItem(nodeIdentifier);
                    }
                    catch (Exception e) {
                        isUUID = true;
                    }
                    if (!isUUID) ** GOTO lbl74
                    try {
                        uuid = params[params.length - 1];
                        currentNode = session.getNodeByUUID(uuid);
                    }
                    catch (ItemNotFoundException exc) {
                        this.renderErrorMessage(context, "UIMessageBoard.msg.content-not-found");
                        return;
                    }
                }
                if (params.length != 2) ** GOTO lbl74
                currentNode = session.getRootNode();
            }
            catch (RepositoryException re) {
                repository = porletRequestContext.getRequest().getPreferences().getValue("repository", "");
                taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
                taxonomyTree = taxonomyService.getTaxonomyTree(repository, params[0]);
                symLinkPath = parameters.substring(parameters.indexOf("/") + 1);
                try {
                    symLink = taxonomyTree.getNode(symLinkPath);
                    currentNode = taxonomyTree.getSession().getNodeByUUID(symLink.getProperty("exo:uuid").getString());
                }
                catch (PathNotFoundException e) {
                    this.renderErrorMessage(context, "UIMessageBoard.msg.content-not-found");
                }
            }
            catch (AccessControlException ace) {
                this.renderErrorMessage(context, "UIMessageBoard.msg.access-control-exc");
                return;
            }
            catch (Exception e) {
                this.renderErrorMessage(context, "UIMessageBoard.msg.content-not-found");
                return;
            }
        } else {
            currentNode = (Node)object;
        }
lbl74:
        // 7 sources

        templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        documentTypes = templateService.getDocumentTemplates(repository);
        isDocumentType = false;
        for (String docType : documentTypes) {
            if (!currentNode.isNodeType(docType)) continue;
            isDocumentType = true;
            break;
        }
        if (currentNode.isNodeType("exo:hiddenable")) {
            this.renderErrorMessage(context, "UIMessageBoard.msg.access-control-exc");
            return;
        }
        if (isDocumentType.booleanValue()) {
            if (this.hasChildren()) {
                this.removeChild(UIContentViewerContainer.class);
            }
            publicationService = (PublicationService)uiPortal.getApplicationComponent(PublicationService.class);
            hmContext = new HashMap<String, StageAndVersionPublicationConstant.SITE_MODE>();
            if (Utils.isLiveMode()) {
                hmContext.put(StageAndVersionPublicationConstant.RUNTIME_MODE, StageAndVersionPublicationConstant.SITE_MODE.LIVE);
            } else {
                hmContext.put(StageAndVersionPublicationConstant.RUNTIME_MODE, StageAndVersionPublicationConstant.SITE_MODE.EDITING);
            }
            lifeCycleName = null;
            try {
                lifeCycleName = publicationService.getNodeLifecycleName(currentNode);
            }
            catch (NotInPublicationLifecycleException e) {
                // empty catch block
            }
            if (lifeCycleName == null) {
                nodeView = currentNode;
            } else {
                publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifeCycleName);
                if (publicationPlugin == null) {
                    this.renderErrorMessage(context, "UIMessageBoard.msg.content-invisible");
                    return;
                }
                nodeView = publicationPlugin.getNodeView(currentNode, hmContext);
            }
            isLiveMode = Utils.isLiveMode();
            if (isLiveMode) {
                if (nodeView == null) {
                    this.renderErrorMessage(context, "UIMessageBoard.msg.content-invisible");
                    return;
                }
                this.uiContentViewer.setNode(nodeView);
            } else {
                this.uiContentViewer.setNode(currentNode);
            }
            this.uiContentViewer.setRepository(repository);
            this.uiContentViewer.setWorkspace(workspace);
            this.uiContentViewer.setOrginalNode(currentNode);
            state = StageAndVersionPublicationState.getRevisionState((Node)currentNode);
            if (StageAndVersionPublicationConstant.OBSOLETE_STATE.equals(state)) {
                this.setObsoletedContent(true);
                this.renderErrorMessage(context, "UIMessageBoard.msg.content-obsolete");
                return;
            }
            this.setObsoletedContent(false);
            if (StageAndVersionPublicationConstant.DRAFT_STATE.equals(state) && !isLiveMode) {
                this.setDraftRevision(true);
            } else {
                this.setDraftRevision(false);
            }
            request = (HttpServletRequest)context.getRequest();
            this.isPrint = "isPrint=true".equals(request.getQueryString()) != false;
            super.processRender(context);
        } else {
            this.renderErrorMessage(context, "UIMessageBoard.msg.content-unsupport-exc");
        }
    }

    public boolean isQuickEditAble() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return Utils.turnOnQuickEditable((PortletRequestContext)context, (boolean)true);
    }

    public void renderErrorMessage(WebuiRequestContext context, String keyBundle) throws Exception {
        Writer writer = context.getWriter();
        String message = context.getApplicationResourceBundle().getString(keyBundle);
        writer.write("<div style=\"height: 55px; font-size: 13px; text-align: center; padding-top: 10px;\">");
        writer.write("<span>");
        writer.write(message);
        writer.write("</span>");
        writer.write("</div>");
        writer.close();
    }

    public boolean getIsPrint() {
        return this.isPrint;
    }

    public void setIsPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public boolean isDraftRevision() {
        return this.isDraftRevision;
    }

    public void setDraftRevision(boolean isDraftRevision) {
        this.isDraftRevision = isDraftRevision;
    }

    public boolean isObsoletedContent() {
        return this.isObsoletedContent;
    }

    public void setObsoletedContent(boolean isObsoletedContent) {
        this.isObsoletedContent = isObsoletedContent;
    }
}

