/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationState;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationUtil;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/SingleContentViewer/UIPresentationContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIPresentationContainer
extends UIContainer {
    private boolean isDraftRevision = false;
    private boolean isObsoletedContent = false;
    private boolean hasLiveRevision = false;

    public UIPresentationContainer() throws Exception {
        this.addChild(UIPresentation.class, null, "UIPresentation");
    }

    public boolean isQuickEditable() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return Utils.turnOnQuickEditable((PortletRequestContext)portletRequestContext, (boolean)true);
    }

    public boolean isObsoletedContent() {
        return this.isObsoletedContent;
    }

    public void setObsoletedContent(boolean isObsoletedContent) {
        this.isObsoletedContent = isObsoletedContent;
    }

    private boolean isDraftRevision() {
        return this.isDraftRevision;
    }

    private void setDraftRevision(boolean isDraftRevision) {
        this.isDraftRevision = isDraftRevision;
    }

    public boolean hasLiveRevision() {
        return this.hasLiveRevision;
    }

    private void setHasLiveRevision(boolean hasLiveRevision) {
        this.hasLiveRevision = hasLiveRevision;
    }

    public boolean isEditable() {
        UISingleContentViewerPortlet uiportlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
        Node originalNode = null;
        try {
            originalNode = uiportlet.getReferencedContent();
        }
        catch (ItemNotFoundException ex) {
            originalNode = null;
        }
        catch (RepositoryException rx) {
            originalNode = null;
        }
        catch (Exception rx) {
            originalNode = null;
        }
        try {
            ((ExtendedNode)originalNode).checkPermission("set_property");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UISingleContentViewerPortlet uiportlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
        Node originalNode = null;
        this.setHasLiveRevision(false);
        try {
            originalNode = uiportlet.getReferencedContent();
        }
        catch (ItemNotFoundException ex) {
            originalNode = null;
        }
        catch (RepositoryException rx) {
            originalNode = null;
        }
        ExtendedNode curnode = (ExtendedNode)originalNode;
        String currentState = StageAndVersionPublicationState.getRevisionState((Node)originalNode);
        if (StageAndVersionPublicationConstant.OBSOLETE_STATE.equals(currentState)) {
            this.setObsoletedContent(true);
        } else {
            this.setObsoletedContent(false);
            UIPresentation livePresentation = (UIPresentation)this.getChild(UIPresentation.class);
            if (Utils.isLiveMode()) {
                Node liveRevision = this.getLiveRevision(originalNode);
                if (liveRevision != null) {
                    this.setHasLiveRevision(true);
                }
                livePresentation.setOriginalNode(originalNode);
                livePresentation.setViewNode(liveRevision);
                this.setDraftRevision(false);
            } else if (StageAndVersionPublicationConstant.DRAFT_STATE.equals(currentState)) {
                livePresentation.setViewNode(originalNode);
                livePresentation.setOriginalNode(originalNode);
                this.setDraftRevision(true);
            } else if (StageAndVersionPublicationConstant.LIVE_STATE.equals(currentState)) {
                Node liveRevision = this.getLiveRevision(originalNode);
                if (liveRevision != null) {
                    this.setHasLiveRevision(true);
                }
                livePresentation.setOriginalNode(originalNode);
                livePresentation.setViewNode(liveRevision);
                this.setDraftRevision(false);
            }
        }
        super.processRender(context);
    }

    private Node getLiveRevision(Node content) throws Exception {
        if (content == null) {
            return null;
        }
        HashMap<String, StageAndVersionPublicationConstant.SITE_MODE> context = new HashMap<String, StageAndVersionPublicationConstant.SITE_MODE>();
        context.put(StageAndVersionPublicationConstant.RUNTIME_MODE, StageAndVersionPublicationConstant.SITE_MODE.LIVE);
        PublicationService pubService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        String lifecycleName = null;
        try {
            lifecycleName = pubService.getNodeLifecycleName(content);
        }
        catch (NotInPublicationLifecycleException e) {
            // empty catch block
        }
        if (lifecycleName == null) {
            return content;
        }
        PublicationPlugin pubPlugin = (PublicationPlugin)pubService.getPublicationPlugins().get(lifecycleName);
        return pubPlugin.getNodeView(content, context);
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }

    public boolean isQuickPrint() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        PortletPreferences prefs = porletRequestContext.getRequest().getPreferences();
        UIPortal uiPortal = Util.getUIPortal();
        UIPage uiPage = (UIPage)uiPortal.findFirstComponentOfType(UIPage.class);
        if (uiPage == null) {
            return false;
        }
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        List ids = StageAndVersionPublicationUtil.getListApplicationIdByPage((Page)PortalDataMapper.toPageModel((UIPage)uiPage), (String)wcmConfigurationService.getPublishingPortletName());
        ArrayList<String> newIds = new ArrayList<String>();
        int length = ids.size();
        for (int i = 0; i < length; ++i) {
            String temp = (String)ids.get(i);
            String id = temp.substring(temp.lastIndexOf("/") + 1, temp.length());
            newIds.add(id);
        }
        return newIds.contains(porletRequestContext.getWindowId()) && "true".equals(prefs.getValue("ShowPrintAction", null));
    }
}

