/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.RefreshDelegateActionListener;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UICLVContainer
extends UIContainer
implements RefreshDelegateActionListener {
    protected boolean viewAbleContent = false;
    protected String messageKey;

    public abstract void init() throws Exception;

    public String getMessage() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return requestContext.getApplicationResourceBundle().getString(this.messageKey);
    }

    public boolean isViewAbleContent() {
        return this.viewAbleContent;
    }

    public void setViewAbleContent(boolean bool) {
        this.viewAbleContent = bool;
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (!Utils.isLiveMode() || context.getFullRender()) {
            this.init();
        }
        super.processRender(context);
    }

    protected PortletPreferences getPortletPreference() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    protected String getFormViewTemplatePath() {
        return this.getPortletPreference().getValue("formViewTemplatePath", null);
    }

    public ResourceResolver getTemplateResourceResolver() throws Exception {
        String repository = this.getPortletPreference().getValue("repository", null);
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig(repository).getSystemWorkspace();
        return new JCRResourceResolver(repository, workspace, "exo:templateFile");
    }

    public void onRefresh(Event<UICLVPresentation> event) throws Exception {
        UICLVPresentation contentListPresentation = (UICLVPresentation)event.getSource();
        UICLVContainer uiListViewerBase = (UICLVContainer)contentListPresentation.getParent();
        uiListViewerBase.getChildren().clear();
        uiListViewerBase.init();
    }
}

