/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.HashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UICLVManualMode.gtmpl", events={@EventConfig(listeners={UICLVContainer.QuickEditActionListener.class})})
public class UICLVFolderMode
extends UICLVContainer {
    public void init() throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreference();
        NodeIterator nodeIterator = null;
        this.setViewAbleContent(true);
        this.messageKey = null;
        try {
            nodeIterator = this.getRenderedContentNodes();
        }
        catch (ItemNotFoundException e) {
            this.messageKey = "UIMessageBoard.msg.folder-not-found";
            this.setViewAbleContent(false);
            return;
        }
        catch (AccessDeniedException e) {
            this.messageKey = "UIMessageBoard.msg.no-permission";
            this.setViewAbleContent(false);
            return;
        }
        catch (Exception e) {
            this.messageKey = "UIMessageBoard.msg.error-nodetype";
            this.setViewAbleContent(false);
            return;
        }
        if (nodeIterator.getSize() == 0L) {
            this.messageKey = "UIMessageBoard.msg.folder-empty";
            this.setViewAbleContent(false);
            return;
        }
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        PaginatedNodeIterator paginatedNodeIterator = new PaginatedNodeIterator(nodeIterator, itemsPerPage);
        this.getChildren().clear();
        UICLVPresentation contentListPresentation = (UICLVPresentation)this.addChild(UICLVPresentation.class, null, null);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        contentListPresentation.init(templatePath, resourceResolver, (PageList)paginatedNodeIterator);
        contentListPresentation.setContentColumn(portletPreferences.getValue("header", null));
        contentListPresentation.setShowLink(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        contentListPresentation.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        contentListPresentation.setShowReadmore(Boolean.parseBoolean(portletPreferences.getValue("showReadmore", null)));
        contentListPresentation.setHeader(portletPreferences.getValue("header", null));
    }

    public NodeIterator getRenderedContentNodes() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String repository = preferences.getValue("repository", null);
        String workspace = preferences.getValue("workspace", null);
        String folderPath = preferences.getValue("folderPath", null);
        if (repository == null || workspace == null || folderPath == null) {
            throw new ItemNotFoundException();
        }
        WCMComposer wcmComposer = (WCMComposer)this.getApplicationComponent(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", Utils.isLiveMode() ? "Live" : "Edit");
        String orderBy = preferences.getValue("orderBy", null);
        String orderType = preferences.getValue("orderType", null);
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "exo:title";
        }
        filters.put("filter-order-by", orderBy);
        filters.put("filter-order-type", orderType);
        return wcmComposer.getContents(repository, workspace, folderPath, filters);
    }
}

