/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationUtil;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/SingleContentViewer/UIPresentationContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIPresentationContainer
extends UIContainer {
    private boolean isDraftRevision = false;
    private boolean isShowDraft = false;
    private Node nodeReference;

    public boolean isShowDraft() {
        return this.isShowDraft;
    }

    public void setShowDraft(boolean isShowDraft) {
        this.isShowDraft = isShowDraft;
    }

    public UIPresentationContainer() throws Exception {
        this.addChild(UIPresentation.class, null, null);
    }

    public boolean isQuickEditable() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return Utils.turnOnQuickEditable((PortletRequestContext)portletRequestContext, (boolean)true);
    }

    public boolean isDraftRevision() {
        return this.isDraftRevision;
    }

    public void setDraftRevision(boolean isDraftRevision) {
        this.isDraftRevision = isDraftRevision;
    }

    public boolean isEditable() throws Exception {
        Node originalNode = null;
        try {
            originalNode = this.getReferenceNode();
        }
        catch (ItemNotFoundException ex) {
            originalNode = null;
        }
        catch (RepositoryException rx) {
            originalNode = null;
        }
        catch (Exception rx) {
            originalNode = null;
        }
        try {
            ((ExtendedNode)originalNode).checkPermission("set_property");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public Node getReferenceNode() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String repository = preferences.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
        String workspace = preferences.getValue(UISingleContentViewerPortlet.WORKSPACE, null);
        String nodeIdentifier = preferences.getValue(UISingleContentViewerPortlet.IDENTIFIER, null);
        WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
        try {
            this.nodeReference = wcmService.getReferencedContent(repository, workspace, nodeIdentifier, Utils.getSessionProvider((org.exoplatform.webui.core.UIContainer)this));
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        String lifecycleName = null;
        try {
            lifecycleName = publicationService.getNodeLifecycleName(this.nodeReference);
        }
        catch (NotInPublicationLifecycleException e) {
            // empty catch block
        }
        if (lifecycleName == null) {
            return this.nodeReference;
        }
        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifecycleName);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("filter-mode", Utils.getCurrentMode());
        return publicationPlugin.getNodeView(this.nodeReference, context);
    }

    public Node getNode() throws Exception {
        Node nodeView = this.getReferenceNode();
        WCMPublicationService wcmPublicationService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        String contentState = wcmPublicationService.getContentState(nodeView);
        this.isDraftRevision = "draft".equals(contentState);
        this.isShowDraft = "Edit".equals(Utils.getCurrentMode());
        UIPresentation presentation = (UIPresentation)this.getChild(UIPresentation.class);
        if (nodeView != null && nodeView.isNodeType("nt:frozenNode")) {
            String nodeUUID = nodeView.getProperty("jcr:frozenUuid").getString();
            presentation.setOriginalNode(this.nodeReference.getSession().getNodeByUUID(nodeUUID));
            presentation.setNode(nodeView);
        } else {
            presentation.setOriginalNode(nodeView);
            presentation.setNode(nodeView);
        }
        return nodeView;
    }

    public boolean isQuickPrint() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        PortletPreferences prefs = porletRequestContext.getRequest().getPreferences();
        UIPortal uiPortal = Util.getUIPortal();
        UIPage uiPage = (UIPage)uiPortal.findFirstComponentOfType(UIPage.class);
        if (uiPage == null) {
            return false;
        }
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        List ids = StageAndVersionPublicationUtil.getListApplicationIdByPage((Page)PortalDataMapper.toPageModel((UIPage)uiPage), (String)wcmConfigurationService.getRuntimeContextParam("SCVPortlet"));
        ArrayList<String> newIds = new ArrayList<String>();
        int length = ids.size();
        for (int i = 0; i < length; ++i) {
            String temp = (String)ids.get(i);
            String id = temp.substring(temp.lastIndexOf("/") + 1, temp.length());
            newIds.add(id);
        }
        return newIds.contains(porletRequestContext.getWindowId()) && "true".equals(prefs.getValue("ShowPrintAction", null));
    }
}

