/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search;

import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequestWrapper;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.WCMPaginatedQueryResult;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.wcm.webui.search.UISearchForm;
import org.exoplatform.wcm.webui.search.UISearchResult;
import org.exoplatform.wcm.webui.search.UIWCMSearchPortlet;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={EditContentActionListener.class})}), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UISearchResult
extends UIContainer {
    public static final String DRAFT = "draft".intern();
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private String keyword;
    private String resultType;
    private String suggestion;
    private String suggestionURL;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private float searchTime;
    public static final String PARAMETER_REGX = "(portal=.*)&(keyword=.*)";
    public static final String RESULT_NOT_FOUND = "UISearchResult.msg.result-not-found";

    public void init(String templatePath, ResourceResolver resourceResolver) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        String paginatorTemplatePath = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_PAGINATOR_TEMPLATE_PATH, null);
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer writer = context.getWriter();
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        ResourceBundle bundle = context.getApplicationResourceBundle();
        PortletPreferences portletPreferences = porletRequestContext.getRequest().getPreferences();
        if (this.resultType == null || this.resultType.length() == 0) {
            this.resultType = bundle.getString("UISearchForm.documentCheckBox.label") + " & " + bundle.getString("UISearchForm.pageCheckBox.label");
        }
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        String queryString = requestWrapper.getQueryString();
        String message1 = bundle.getString("UISearchResult.msg.your-search");
        String message2 = bundle.getString("UISearchResult.msg.did-not-match");
        String suggestions = bundle.getString("UISearchResult.msg.suggestions");
        String keyword_entered = bundle.getString("UISearchResult.msg.keyword_entered");
        if (queryString != null && queryString.trim().length() != 0 && queryString.matches(PARAMETER_REGX)) {
            queryString = URLDecoder.decode(queryString, "UTF-8");
            String[] params = queryString.split("&");
            String portalParam = params[0];
            String currentPortal = portalParam.split("=")[1];
            String keywordParam = queryString.substring(portalParam.length() + 1);
            String keyword = keywordParam.substring("keyword=".length());
            if (keyword == null || keyword.trim().length() == 0) {
                writer.write("<div class=\"UIAdvanceSearchResultDefault\">");
                writer.write("<div class=\"ResultHeader\"><div class=\"CaptionSearchType\"><b>" + this.getResultType() + "</b></div><div style=\"clear: left;\"><span></span></div></div>");
                writer.write("<p>" + keyword_entered + "</p>");
                return;
            }
            this.setKeyword(keyword);
            SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
            QueryCriteria queryCriteria = new QueryCriteria();
            queryCriteria.setSiteName(currentPortal);
            queryCriteria.setKeyword(keyword);
            queryCriteria.setSearchWebpage(true);
            queryCriteria.setSearchDocument(true);
            SessionProvider provider = SessionProviderFactory.createSessionProvider();
            int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
            try {
                WCMPaginatedQueryResult paginatedQueryResult = siteSearchService.searchSiteContents(queryCriteria, provider, itemsPerPage);
                this.setSearchTime(paginatedQueryResult.getQueryTimeInSecond());
                this.setSuggestion(paginatedQueryResult.getSpellSuggestion());
                String suggestionURL = Util.getPortalRequestContext().getRequestURI();
                suggestionURL = suggestionURL + "?portal=" + currentPortal + "&keyword=" + this.getSuggestion();
                this.setSuggestionURL(suggestionURL);
                this.setPageList((PageList)paginatedQueryResult);
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage(UISearchForm.MESSAGE_NOT_SUPPORT_KEYWORD, null, 1));
            }
        } else if (queryString == null || queryString.trim().length() == 0) {
            writer.write("<div class=\"UIAdvanceSearchResultDefault\">");
            writer.write("<div class=\"ResultHeader\"><div class=\"CaptionSearchType\"><b>" + this.getResultType() + "</b></div><div style=\"clear: left;\"><span></span></div></div>");
            writer.write("<p>" + keyword_entered + "</p>");
            return;
        }
        if (this.uiPaginator.getTotalItems() == 0) {
            String keyword = this.getKeyword();
            writer.write("<div class=\"UIAdvanceSearchResultDefault\">");
            writer.write("<div class=\"ResultHeader\"><div class=\"CaptionSearchType\"><b>" + this.getResultType() + "</b></div><div style=\"clear: left;\"><span></span></div></div>");
            if (keyword == null || keyword.trim().length() == 0) {
                writer.write("<p>" + keyword_entered + "</p>");
            } else {
                writer.write("<p>");
                writer.write(message1 + " - <b style=\"font-size: 15px; font-style: italic;\">" + keyword + "</b> - " + message2 + "&nbsp;" + this.getResultType().toLowerCase() + "&nbsp;" + "<br><br>");
                writer.write(suggestions + "<br>");
                String keySuggestion = this.getSuggestion();
                if (keySuggestion == null || keySuggestion.equals("null")) {
                    String newKeyword = bundle.getString("UISearchResult.msg.try-different-key");
                    writer.write("<ul><li>" + newKeyword + "</li></ul>");
                } else {
                    this.setKeyword(keySuggestion);
                    writer.write("<ul><li><a class=\"KeySuggestions\" style=\"cursor: pointer;\">" + keySuggestion + "</a></li></ul>");
                }
                writer.write("</p>");
            }
            writer.write("</div>");
            return;
        }
        super.processRender(context);
    }

    public void setPageList(PageList dataPageList) {
        this.uiPaginator.setPageList(dataPageList);
    }

    public int getTotalItem() {
        return this.uiPaginator.getPageList().getAvailable();
    }

    public int getItemsPerPage() {
        return this.uiPaginator.getPageList().getPageSize();
    }

    public int getCurrentPage() {
        return this.uiPaginator.getCurrentPage();
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public List getCurrentPageData() throws Exception {
        return this.uiPaginator.getCurrentPageData();
    }

    public String getTitle(Node node) throws Exception {
        return node.hasProperty("exo:title") ? node.getProperty("exo:title").getValue().getString() : node.getName();
    }

    public List<String> getURLs(Node node) throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        if (!node.hasProperty("publication:navigationNodeURIs")) {
            urls.add(this.getURL(node));
        } else {
            for (Value value : node.getProperty("publication:navigationNodeURIs").getValues()) {
                urls.add(value.getString());
            }
        }
        return urls;
    }

    public boolean showDraftButton(Node node) throws Exception {
        Object obj = Util.getPortalRequestContext().getRequest().getSession().getAttribute("turnOnQuickEdit");
        if (obj == null) {
            return false;
        }
        String currentState = null;
        try {
            currentState = node.getProperty("publication:currentState").getString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return Boolean.parseBoolean(obj.toString()) && DRAFT.equals(currentState);
    }

    public Node getNodeView(Node node) throws Exception {
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        HashMap<String, StageAndVersionPublicationConstant.SITE_MODE> context = new HashMap<String, StageAndVersionPublicationConstant.SITE_MODE>();
        if (Utils.isLiveMode()) {
            context.put(StageAndVersionPublicationConstant.RUNTIME_MODE, StageAndVersionPublicationConstant.SITE_MODE.LIVE);
        } else {
            context.put(StageAndVersionPublicationConstant.RUNTIME_MODE, StageAndVersionPublicationConstant.SITE_MODE.EDITING);
        }
        String lifecyleName = publicationService.getNodeLifecycleName(node);
        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifecyleName);
        Node viewNode = publicationPlugin.getNodeView(node, context);
        return viewNode;
    }

    public String getPublishedNodeURI(String navNodeURI) {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String accessMode = null;
        accessMode = portalRequestContext.getAccessPath() == 0 ? "public" : "private";
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String baseURI = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        if (navNodeURI.startsWith(baseURI)) {
            return navNodeURI;
        }
        return baseURI + portalRequestContext.getRequestContextPath() + "/" + accessMode + navNodeURI;
    }

    public String getURL(Node node) throws Exception {
        String link = null;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String portalURI = portalRequestContext.getPortalURI();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        String repository = portletPreferences.getValue("repository", null);
        String workspace = portletPreferences.getValue("workspace", null);
        String baseURI = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        String parameterizedPageURI = wcmConfigurationService.getParameterizedPageURI();
        link = baseURI + portalURI + parameterizedPageURI.substring(1, parameterizedPageURI.length()) + "/" + repository + "/" + workspace + node.getPath();
        return link;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public boolean isShowPaginator() throws Exception {
        PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public float getSearchTime() {
        return this.searchTime;
    }

    public void setSearchTime(float searchTime) {
        this.searchTime = searchTime;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public String getSuggestionURL() {
        return this.suggestionURL;
    }

    public void setSuggestionURL(String suggestionURL) {
        this.suggestionURL = suggestionURL;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public int getNumberOfPage() {
        return this.uiPaginator.getPageList().getAvailablePage();
    }
}

