/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.wcm.webui.clv.UIContentListPresentation;
import org.exoplatform.wcm.webui.clv.UIListViewerBase;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UIContentListViewer.gtmpl", events={@EventConfig(listeners={UIListViewerBase.QuickEditActionListener.class})})
public class UICorrectContentsViewer
extends UIListViewerBase {
    public void init() throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreference();
        this.setViewAbleContent(true);
        String repository = portletPreferences.getValue("repository", null);
        String workspace = portletPreferences.getValue("workspace", null);
        WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
        Node root = wcmService.getRootNode(repository, workspace);
        String[] listContent = portletPreferences.getValues("contents", null);
        if (listContent == null || listContent.length == 0) {
            this.messageKey = "UIMessageBoard.msg.contents-not-found";
            this.setViewAbleContent(false);
            return;
        }
        List<String> contents = Arrays.asList(listContent);
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<String> tempContents = new ArrayList<String>(contents);
        if (contents != null && contents.size() != 0) {
            for (int i = 0; i < contents.size(); ++i) {
                Node node = null;
                String path = contents.get(i);
                try {
                    node = root.getNode(path.substring(1, path.length()));
                }
                catch (Exception e) {
                    tempContents.remove(i);
                }
                if (node == null) continue;
                nodes.add(node);
            }
        }
        if (nodes.size() == 0) {
            this.messageKey = "UIMessageBoard.msg.contents-not-found";
            this.setViewAbleContent(false);
            return;
        }
        if (tempContents.size() != contents.size()) {
            portletPreferences.setValues("contents", tempContents.toArray(new String[0]));
            portletPreferences.store();
        }
        this.getChildren().clear();
        ObjectPageList pageList = new ObjectPageList(nodes, itemsPerPage);
        UIContentListPresentation contentListPresentation = (UIContentListPresentation)this.addChild(UIContentListPresentation.class, null, null);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        contentListPresentation.init(templatePath, resourceResolver, (PageList)pageList);
        contentListPresentation.setContentColumn(portletPreferences.getValue("header", null));
        contentListPresentation.setShowLink(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        contentListPresentation.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        contentListPresentation.setHeader(portletPreferences.getValue("header", null));
    }
}

