/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui;

import com.ibm.icu.text.Transliterator;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

public class Utils {
    public static final String TURN_ON_QUICK_EDIT = "turnOnQuickEdit";

    public static boolean isEditPortletInCreatePageWizard() {
        UIPortal uiPortal = Util.getUIPortal();
        UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
        return uiMaskWS.getWindowWidth() > 0 && uiMaskWS.getWindowHeight() < 0;
    }

    public static void refreshBrowser(PortletRequestContext context) {
        context.getJavascriptManager().addJavascript((CharSequence)"location.reload();");
    }

    public static boolean canEditCurrentPortal(String remoteUser) throws Exception {
        if (remoteUser == null) {
            return false;
        }
        IdentityRegistry identityRegistry = (IdentityRegistry)Util.getUIPortalApplication().getApplicationComponent(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(remoteUser);
        if (identity == null) {
            return false;
        }
        UIPortal uiPortal = Util.getUIPortal();
        String editPermission = uiPortal.getEditPermission();
        MembershipEntry membershipEntry = MembershipEntry.parse((String)editPermission);
        return identity.isMemberOf(membershipEntry);
    }

    public static boolean turnOnQuickEditable(PortletRequestContext context, boolean showAblePref) throws Exception {
        Object obj = Util.getPortalRequestContext().getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        boolean turnOnFlag = false;
        if (obj != null) {
            turnOnFlag = Boolean.parseBoolean(obj.toString());
        }
        String remoteUser = context.getRemoteUser();
        return showAblePref && turnOnFlag && Utils.canEditCurrentPortal(remoteUser);
    }

    public static boolean isLiveMode() {
        Object obj = Util.getPortalRequestContext().getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        if (obj == null) {
            return true;
        }
        return !Boolean.parseBoolean(obj.toString());
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '_') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '_';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '_') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 95 || cleanedStr.charAt(i - 1) != '_') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }
}

